/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.lib.Log;

public class LegacyAreaWidgetConverter {
    private static final Map<String, EnumOldAreaType> OLD_AREA_TYPE_MAP = new HashMap<String, EnumOldAreaType>();
    private static final Map<EnumOldAreaType, String> oldFormatToAreaTypes = new EnumMap<EnumOldAreaType, String>(EnumOldAreaType.class);

    private static void register(String id, EnumOldAreaType ... oldTypes) {
        for (EnumOldAreaType oldType : oldTypes) {
            oldFormatToAreaTypes.put(oldType, id);
        }
    }

    public static AreaType convertFromLegacyFormat(EnumOldAreaType oldType, int typeInfo) {
        String newTypeId = oldFormatToAreaTypes.get((Object)oldType);
        if (newTypeId == null) {
            Log.error("Legacy import: no area converter found for " + oldType + "! Substituting 'box'.", new Object[0]);
            return new AreaTypeBox();
        }
        AreaType type = ProgWidgetArea.createType(newTypeId);
        type.convertFromLegacy(oldType, typeInfo);
        return type;
    }

    static {
        LegacyAreaWidgetConverter.register("box", EnumOldAreaType.FILL, EnumOldAreaType.WALL, EnumOldAreaType.FRAME);
        LegacyAreaWidgetConverter.register("sphere", EnumOldAreaType.SPHERE);
        LegacyAreaWidgetConverter.register("line", EnumOldAreaType.LINE);
        LegacyAreaWidgetConverter.register("wall", EnumOldAreaType.X_WALL, EnumOldAreaType.Y_WALL, EnumOldAreaType.Z_WALL);
        LegacyAreaWidgetConverter.register("cylinder", EnumOldAreaType.X_CYLINDER, EnumOldAreaType.Y_CYLINDER, EnumOldAreaType.Z_CYLINDER);
        LegacyAreaWidgetConverter.register("pyramid", EnumOldAreaType.X_PYRAMID, EnumOldAreaType.Y_PYRAMID, EnumOldAreaType.Z_PYRAMID);
        LegacyAreaWidgetConverter.register("grid", EnumOldAreaType.GRID);
        LegacyAreaWidgetConverter.register("random", EnumOldAreaType.RANDOM);
        if (oldFormatToAreaTypes.size() != EnumOldAreaType.values().length) {
            throw new IllegalStateException("Not all old formats are handled!");
        }
        for (EnumOldAreaType oldAreaType : EnumOldAreaType.values()) {
            OLD_AREA_TYPE_MAP.put(oldAreaType.name.toLowerCase(Locale.ROOT), oldAreaType);
        }
    }

    public static enum EnumOldAreaType {
        FILL("Filled"),
        FRAME("Frame"),
        WALL("Walls"),
        SPHERE("Sphere"),
        LINE("Line"),
        X_WALL("X-Wall"),
        Y_WALL("Y-Wall"),
        Z_WALL("Z-Wall"),
        X_CYLINDER("X-Cylinder"),
        Y_CYLINDER("Y-Cylinder"),
        Z_CYLINDER("Z-Cylinder"),
        X_PYRAMID("X-Pyramid"),
        Y_PYRAMID("Y-Pyramid"),
        Z_PYRAMID("Z-Pyramid"),
        GRID("Grid", true),
        RANDOM("Random", true);

        private final String name;
        public final boolean utilizesTypeInfo;

        private EnumOldAreaType(String name) {
            this(name, false);
        }

        private EnumOldAreaType(String name, boolean utilizesTypeInfo) {
            this.name = name;
            this.utilizesTypeInfo = utilizesTypeInfo;
        }

        public static EnumOldAreaType byName(String name) {
            return OLD_AREA_TYPE_MAP.get(name.toLowerCase(Locale.ROOT));
        }

        public String toString() {
            return this.name;
        }
    }
}

