/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PressureChamberRecipeImpl
extends PressureChamberRecipe {
    private final float pressureRequired;
    private final List<Ingredient> inputs;
    private final NonNullList<ItemStack> outputs;

    public PressureChamberRecipeImpl(ResourceLocation id, List<Ingredient> inputs, float pressureRequired, ItemStack ... outputs) {
        super(id);
        this.inputs = ImmutableList.copyOf(inputs);
        this.outputs = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])outputs);
        this.pressureRequired = pressureRequired;
    }

    @Override
    public float getCraftingPressure(IItemHandler chamberHandler, IntList ingredientSlots) {
        return this.pressureRequired;
    }

    @Override
    public float getCraftingPressureForDisplay() {
        return this.pressureRequired;
    }

    @Override
    public IntCollection findIngredients(IItemHandler chamberHandler) {
        Set inputSet = Sets.newIdentityHashSet();
        inputSet.addAll(this.inputs);
        IntArrayList slots = new IntArrayList();
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            if (chamberHandler.getStackInSlot(i).m_41619_()) continue;
            Iterator iter = inputSet.iterator();
            while (iter.hasNext()) {
                Ingredient ingr = (Ingredient)iter.next();
                if (!ingr.test(chamberHandler.getStackInSlot(i))) continue;
                iter.remove();
                slots.add(i);
                break;
            }
            if (slots.size() != this.inputs.size()) continue;
            return slots;
        }
        return IntList.of();
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        return new ArrayList<Ingredient>(this.inputs);
    }

    @Override
    protected List<ItemStack> getSingleResultsForDisplay() {
        return this.outputs;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.PRESSURE_CHAMBER.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.PRESSURE_CHAMBER.get();
    }

    public String m_6076_() {
        return "pneumaticcraft:pressure_chamber";
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_WALL.get());
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        ItemStack s2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.m_41741_());
        return this.inputs.stream().anyMatch(ingr -> ingr.test(s2));
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, IntList ingredientSlots, boolean simulate) {
        for (Ingredient ingredient : this.inputs) {
            if (ingredient.m_43947_()) {
                return NonNullList.m_122779_();
            }
            int nItems = ingredient.m_43908_()[0].m_41613_();
            for (int i = 0; i < ingredientSlots.size() && nItems > 0; ++i) {
                int slot = ingredientSlots.get(i);
                if (!ingredient.test(chamberHandler.getStackInSlot(slot))) continue;
                ItemStack extracted = chamberHandler.extractItem(slot, nItems, simulate);
                nItems -= extracted.m_41613_();
            }
        }
        return this.outputs;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getCraftingPressureForDisplay());
        buffer.m_130130_(this.inputs.size());
        this.inputs.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(this.outputs.size());
        this.outputs.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
    }

    public static class Serializer<T extends PressureChamberRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputs = json.get("inputs").getAsJsonArray();
            ArrayList<Ingredient> inputIngredients = new ArrayList<Ingredient>();
            for (JsonElement e : inputs) {
                inputIngredients.add(Ingredient.m_43917_((JsonElement)e.getAsJsonObject()));
            }
            float pressure = GsonHelper.m_13915_((JsonObject)json, (String)"pressure");
            JsonArray outputs = json.get("results").getAsJsonArray();
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement e : outputs) {
                results.add((Object)ShapedRecipe.m_151274_((JsonObject)e.getAsJsonObject()));
            }
            return this.factory.create(recipeId, inputIngredients, pressure, (ItemStack[])results.toArray((Object[])new ItemStack[0]));
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            float pressure = buffer.readFloat();
            int nInputs = buffer.m_130242_();
            ArrayList<Ingredient> in = new ArrayList<Ingredient>();
            for (int i = 0; i < nInputs; ++i) {
                in.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int nOutputs = buffer.m_130242_();
            ItemStack[] out = new ItemStack[nOutputs];
            for (int i = 0; i < nOutputs; ++i) {
                out[i] = buffer.m_130267_();
            }
            return this.factory.create(recipeId, in, pressure, out);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends PressureChamberRecipe> {
            public T create(ResourceLocation var1, List<Ingredient> var2, float var3, ItemStack ... var4);
        }
    }
}

