/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketShiftScrollWheel {
    private final boolean forward;
    private final boolean mainHand;

    public PacketShiftScrollWheel(boolean forward, InteractionHand mainHand) {
        this.forward = forward;
        this.mainHand = mainHand == InteractionHand.MAIN_HAND;
    }

    public PacketShiftScrollWheel(FriendlyByteBuf buf) {
        this.forward = buf.readBoolean();
        this.mainHand = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.mainHand);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_21205_()).m_41720_() instanceof IShiftScrollable) {
                ((IShiftScrollable)stack.m_41720_()).onShiftScrolled((Player)player, this.forward, this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

