/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.network.FilteredSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class NetworkUtils {
    public static List<SyncedField<?>> getSyncedFields(Object syncable, Class<? extends Annotation> searchedAnnotation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> examinedClass = syncable.getClass(); examinedClass != null; examinedClass = examinedClass.getSuperclass()) {
            for (Field field : examinedClass.getDeclaredFields()) {
                if (field.getAnnotation(searchedAnnotation) == null) continue;
                builder.addAll(NetworkUtils.getSyncedFieldsForField(field, syncable, searchedAnnotation));
            }
        }
        return builder.build();
    }

    private static List<SyncedField<?>> getSyncedFieldsForField(Field field, Object te, Class<? extends Annotation> searchedAnnotation) {
        boolean isLazy = field.getAnnotation(LazySynced.class) != null;
        SyncedField<?> syncedField = NetworkUtils.getSyncedFieldForField(field, te);
        if (syncedField != null) {
            return Collections.singletonList(syncedField.setLazy(isLazy));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int filteredIndex = field.getAnnotation(FilteredSynced.class) != null ? field.getAnnotation(FilteredSynced.class).index() : -1;
        try {
            field.setAccessible(true);
            Object o = field.get(te);
            if (o instanceof int[]) {
                int[] array = (int[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedInt(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedInt(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof float[]) {
                float[] array = (float[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedFloat(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedFloat(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof double[]) {
                double[] array = (double[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedDouble(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedDouble(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof boolean[]) {
                boolean[] array = (boolean[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedBoolean(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof String[]) {
                String[] array = (String[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedString(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedString(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o.getClass().isArray() && o.getClass().getComponentType().isEnum()) {
                Object[] enumArray = (Object[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedEnum(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < enumArray.length; ++i) {
                        builder.add(new SyncedField.SyncedEnum(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof ItemStack[]) {
                ItemStack[] array = (ItemStack[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof FluidStack[]) {
                FluidStack[] array = (FluidStack[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedFluidStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedFluidStack(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (o instanceof ItemStackHandler[]) {
                ItemStackHandler[] array = (ItemStackHandler[])o;
                if (filteredIndex >= 0) {
                    builder.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(filteredIndex).setLazy(isLazy));
                } else {
                    for (int i = 0; i < array.length; ++i) {
                        builder.add(new SyncedField.SyncedItemStack(te, field).setArrayIndex(i).setLazy(isLazy));
                    }
                }
            } else if (field.getType().isArray()) {
                Object[] array;
                for (Object obj : array = (Object[])o) {
                    builder.addAll(NetworkUtils.getSyncedFields(obj, searchedAnnotation));
                }
            } else {
                builder.addAll(NetworkUtils.getSyncedFields(o, searchedAnnotation));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ImmutableList syncedFields = builder.build();
        if (syncedFields.isEmpty()) {
            Log.warning("Field " + field + " didn't produce any syncable fields!", new Object[0]);
        }
        return syncedFields;
    }

    private static SyncedField<?> getSyncedFieldForField(Field field, Object te) {
        if (Integer.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedInt(te, field);
        }
        if (Float.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFloat(te, field);
        }
        if (Double.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedDouble(te, field);
        }
        if (Boolean.TYPE.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedBoolean(te, field);
        }
        if (String.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedString(te, field);
        }
        if (field.getType().isEnum()) {
            return new SyncedField.SyncedEnum(te, field);
        }
        if (ItemStack.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedItemStack(te, field);
        }
        if (FluidStack.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedFluidStack(te, field);
        }
        if (IItemHandlerModifiable.class.isAssignableFrom(field.getType())) {
            return new SyncedField.SyncedItemHandler(te, field);
        }
        return null;
    }
}

