/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIExternalProgram;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIPickupItems;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIManager
implements IVariableProvider {
    public static final int TICK_RATE = 3;
    private final List<WrappedGoal> goals = new ArrayList<WrappedGoal>();
    private final List<WrappedGoal> executingGoals = new ArrayList<WrappedGoal>();
    private final ProfilerFiller theProfiler;
    private int tickCount;
    private final IDroneBase drone;
    private List<IProgWidget> progWidgets;
    private IProgWidget activeWidget;
    private IProgWidget startWidget;
    private Goal currentGoal;
    private Goal currentTargetingGoal;
    private boolean stopWhenEndReached;
    private boolean wasAIOveridden;
    private String currentLabel = "Main";
    private Map<String, BlockPos> coordinateVariables = new HashMap<String, BlockPos>();
    private Map<String, ItemStack> itemVariables = new HashMap<String, ItemStack>();
    private final Deque<IProgWidget> jumpBackWidgets = new ArrayDeque<IProgWidget>();
    private static final int MAX_JUMP_STACK_SIZE = 100;

    public DroneAIManager(IDroneBase drone) {
        this.theProfiler = drone.world().m_46473_();
        this.drone = drone;
        if (!drone.world().f_46443_) {
            this.setWidgets(drone.getProgWidgets());
        }
    }

    public DroneAIManager(IDroneBase drone, List<IProgWidget> progWidgets) {
        this.theProfiler = drone.world().m_46473_();
        this.drone = drone;
        this.stopWhenEndReached = true;
        this.setWidgets(progWidgets);
    }

    public void dontStopWhenEndReached() {
        this.stopWhenEndReached = false;
    }

    public void setWidgets(List<IProgWidget> progWidgets) {
        this.progWidgets = ImmutableList.copyOf(progWidgets);
        this.jumpBackWidgets.clear();
        if (progWidgets.isEmpty()) {
            this.setActiveWidget(null);
            this.startWidget = null;
        } else {
            for (IProgWidget widget : progWidgets) {
                if (widget instanceof ProgWidgetStart) {
                    this.startWidget = widget;
                    continue;
                }
                if (!(widget instanceof IVariableWidget)) continue;
                IVariableWidget v = (IVariableWidget)((Object)widget);
                v.setAIManager(this);
            }
            this.restartProgram();
        }
    }

    void connectVariables(DroneAIManager subManager) {
        subManager.coordinateVariables = this.coordinateVariables;
        subManager.itemVariables = this.itemVariables;
    }

    public boolean isIdling() {
        return this.currentGoal == null;
    }

    public Goal getCurrentGoal() {
        return this.currentGoal;
    }

    public IDroneBase getDrone() {
        return this.drone;
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        ListTag tagList = new ListTag();
        for (Map.Entry<String, BlockPos> entry : this.coordinateVariables.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("key", entry.getKey());
            t.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry.getValue()));
            tagList.add((Object)t);
        }
        tag.m_128365_("coords", (Tag)tagList);
        ListTag tagList2 = new ListTag();
        for (Map.Entry<String, ItemStack> entry : this.itemVariables.entrySet()) {
            CompoundTag t = new CompoundTag();
            t.m_128359_("key", entry.getKey());
            t.m_128365_("item", (Tag)entry.getValue().serializeNBT());
            tagList2.add((Object)t);
        }
        tag.m_128365_("items", (Tag)tagList2);
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        this.coordinateVariables.clear();
        ListTag tagList = tag.m_128437_("coords", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag t = tagList.m_128728_(i);
            this.coordinateVariables.put(t.m_128461_("key"), NbtUtils.m_129239_((CompoundTag)t.m_128469_("pos")));
        }
        ListTag tagList2 = tag.m_128437_("items", 10);
        for (int i = 0; i < tagList2.size(); ++i) {
            CompoundTag t = tagList2.m_128728_(i);
            this.itemVariables.put(t.m_128461_("key"), ItemStack.m_41712_((CompoundTag)t.m_128469_("item")));
        }
    }

    @Override
    public Optional<BlockPos> getCoordinate(UUID id, String varName) {
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.CoordinateVariable.Drone event = new SpecialVariableRetrievalEvent.CoordinateVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return Optional.ofNullable(event.getCoordinate());
        }
        if (varName.startsWith("%") || varName.startsWith("#")) {
            return Optional.ofNullable(GlobalVariableHelper.getPos(this.drone.getOwnerUUID(), varName));
        }
        return Optional.ofNullable(this.coordinateVariables.get(varName));
    }

    @Override
    public ItemStack getStack(UUID id, String varName) {
        ItemStack item;
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.ItemVariable.Drone event = new SpecialVariableRetrievalEvent.ItemVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            item = event.getItem();
        } else {
            item = varName.startsWith("#") || varName.startsWith("%") ? GlobalVariableHelper.getStack(this.drone.getOwnerUUID(), varName) : this.itemVariables.getOrDefault(varName, ItemStack.f_41583_);
        }
        return item;
    }

    public void setCoordinate(String varName, BlockPos coord) {
        if (varName.startsWith("%") || varName.startsWith("#")) {
            GlobalVariableHelper.setPos(this.drone.getOwnerUUID(), varName, coord);
        } else if (!varName.startsWith("$")) {
            this.coordinateVariables.put(varName, coord);
            this.drone.onVariableChanged(varName, true);
        }
    }

    public void setStack(String varName, @Nonnull ItemStack item) {
        if (varName.startsWith("#")) {
            GlobalVariableHelper.setStack(this.drone.getOwnerUUID(), varName, item);
        } else if (!varName.startsWith("$")) {
            this.itemVariables.put(varName, item);
            this.drone.onVariableChanged(varName, false);
        }
    }

    private void updateWidgetFlow() {
        boolean isExecuting = this.executingGoals.stream().anyMatch(entry -> this.currentGoal == entry.goal);
        if (!(isExecuting || this.activeWidget == null || this.currentTargetingGoal != null && this.currentTargetingGoal.m_8036_())) {
            this.drone.resetAttackCount();
            IProgWidget widget = this.activeWidget.getOutputWidget(this.drone, this.progWidgets);
            if (widget != null) {
                if (this.activeWidget.getOutputWidget() != widget && this.addJumpBackWidget(this.activeWidget)) {
                    return;
                }
                this.setActiveWidget(widget);
            } else if (this.stopWhenEndReached && this.jumpBackWidgets.isEmpty()) {
                this.setActiveWidget(null);
            } else {
                this.restartProgram();
            }
        }
        if (this.activeWidget == null && !this.stopWhenEndReached) {
            this.restartProgram();
        }
    }

    private void restartProgram() {
        this.setLabel("Main");
        this.setActiveWidget(this.jumpBackWidgets.isEmpty() ? this.startWidget : this.jumpBackWidgets.pop());
    }

    private void setActiveWidget(IProgWidget widget) {
        Goal targetGoal = null;
        Goal goal = null;
        if (widget != null) {
            boolean isStartWidget = widget == this.startWidget;
            targetGoal = widget.getWidgetTargetAI(this.drone, widget);
            goal = widget.getWidgetAI(this.drone, widget);
            HashSet<IProgWidget> visitedWidgets = new HashSet<IProgWidget>();
            while (!visitedWidgets.contains(widget) && targetGoal == null && goal == null) {
                visitedWidgets.add(widget);
                IProgWidget oldWidget = widget;
                widget = widget.getOutputWidget(this.drone, this.progWidgets);
                if (widget == null) {
                    if (!isStartWidget) {
                        if (this.stopWhenEndReached && this.jumpBackWidgets.isEmpty()) {
                            this.setActiveWidget(null);
                        } else {
                            this.restartProgram();
                        }
                    }
                    return;
                }
                if (oldWidget.getOutputWidget() != widget && this.addJumpBackWidget(oldWidget)) {
                    return;
                }
                targetGoal = widget.getWidgetTargetAI(this.drone, widget);
                goal = widget.getWidgetAI(this.drone, widget);
            }
            this.drone.setActiveProgram(widget);
        } else {
            this.setLabel("Stopped");
        }
        this.activeWidget = widget;
        if (this.currentGoal != null) {
            this.removeGoal(this.currentGoal);
        }
        if (this.currentTargetingGoal != null) {
            this.drone.getTargetAI().m_25363_(this.currentTargetingGoal);
        }
        if (goal != null) {
            this.addGoal(2, goal);
        }
        if (targetGoal != null) {
            this.drone.getTargetAI().m_25352_(2, targetGoal);
        }
        this.currentGoal = goal;
        this.currentTargetingGoal = targetGoal;
    }

    private boolean addJumpBackWidget(IProgWidget widget) {
        if (widget instanceof IJumpBackWidget) {
            if (this.jumpBackWidgets.size() >= 100) {
                this.drone.overload("jumpStackTooLarge", 100);
                this.jumpBackWidgets.clear();
                this.setActiveWidget(null);
                return true;
            }
            this.jumpBackWidgets.push(widget);
        }
        return false;
    }

    public List<WrappedGoal> getRunningTasks() {
        return this.goals;
    }

    public Goal getTargetAI() {
        return this.currentTargetingGoal;
    }

    private void addGoal(int priority, Goal goal) {
        this.goals.add(new WrappedGoal(priority, goal));
    }

    private void removeGoal(Goal goal) {
        Iterator<WrappedGoal> iterator = this.goals.iterator();
        while (iterator.hasNext()) {
            WrappedGoal wrappedGoal = iterator.next();
            if (wrappedGoal.goal() != goal) continue;
            if (this.executingGoals.contains(wrappedGoal)) {
                wrappedGoal.goal().m_8041_();
                this.executingGoals.remove(wrappedGoal);
            }
            iterator.remove();
        }
    }

    private void pickupItemsIfMagnet() {
        int magnetUpgrades = this.drone.getUpgrades(ModUpgrades.MAGNET.get());
        if (magnetUpgrades > 0 && !this.drone.getProgWidgets().isEmpty()) {
            int range = Math.min(6, 1 + magnetUpgrades);
            int rangeSq = range * range;
            Vec3 v = this.drone.getDronePos();
            AABB aabb = new AABB(v.f_82479_, v.f_82480_, v.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_).m_82400_((double)range);
            List items = this.drone.world().m_6443_(ItemEntity.class, aabb, item -> item != null && item.m_6084_() && !item.m_32063_() && !ItemRegistry.getInstance().shouldSuppressMagnet((Entity)item) && this.drone.getDronePos().m_82557_(item.m_20182_()) <= (double)rangeSq);
            items.forEach(item -> DroneEntityAIPickupItems.tryPickupItem(this.drone, item));
        }
    }

    public void onUpdateTasks() {
        if (((Boolean)ConfigHelper.common().drones.stopDroneAI.get()).booleanValue()) {
            return;
        }
        this.pickupItemsIfMagnet();
        if (!this.drone.isAIOverridden()) {
            if (this.wasAIOveridden && this.currentTargetingGoal != null) {
                this.drone.getTargetAI().m_25352_(2, this.currentTargetingGoal);
            }
            this.wasAIOveridden = false;
            ArrayList<WrappedGoal> newGoalList = new ArrayList<WrappedGoal>();
            if (this.tickCount++ % 3 == 0) {
                for (WrappedGoal currentGoal : this.goals) {
                    if (this.executingGoals.contains(currentGoal)) {
                        if (this.canUse(currentGoal) && this.canContinue(currentGoal)) continue;
                        currentGoal.goal.m_8041_();
                        this.executingGoals.remove(currentGoal);
                    }
                    if (!this.canUse(currentGoal) || !currentGoal.goal.m_8036_()) continue;
                    newGoalList.add(currentGoal);
                    this.executingGoals.add(currentGoal);
                }
                this.updateWidgetFlow();
            } else {
                Iterator<WrappedGoal> iterator = this.executingGoals.iterator();
                while (iterator.hasNext()) {
                    WrappedGoal currentGoal;
                    currentGoal = iterator.next();
                    if (currentGoal.goal.m_8045_()) continue;
                    currentGoal.goal.m_8041_();
                    iterator.remove();
                }
            }
            this.theProfiler.m_6180_("goalStart");
            for (WrappedGoal currentGoal : newGoalList) {
                this.theProfiler.m_6180_(currentGoal.goal.getClass().getSimpleName());
                currentGoal.goal.m_8056_();
                this.theProfiler.m_7238_();
            }
            this.theProfiler.m_7238_();
            this.theProfiler.m_6180_("goalTick");
            for (WrappedGoal currentGoal : this.executingGoals) {
                currentGoal.goal.m_8037_();
            }
            this.theProfiler.m_7238_();
        } else {
            if (!this.wasAIOveridden && this.currentTargetingGoal != null) {
                this.drone.getTargetAI().m_25363_(this.currentTargetingGoal);
            }
            this.wasAIOveridden = true;
            this.executingGoals.forEach(wrappedGoal -> wrappedGoal.goal.m_8041_());
            this.executingGoals.clear();
            this.drone.setDugBlock(null);
        }
    }

    private boolean canContinue(WrappedGoal par1WrappedGoal) {
        this.theProfiler.m_6180_("canContinue");
        boolean flag = par1WrappedGoal.goal.m_8045_();
        this.theProfiler.m_7238_();
        return flag;
    }

    private boolean canUse(WrappedGoal par1WrappedGoal) {
        this.theProfiler.m_6180_("canUse");
        for (WrappedGoal entry : this.goals) {
            if (entry == par1WrappedGoal) continue;
            if (par1WrappedGoal.priority >= entry.priority) {
                if (!this.executingGoals.contains(entry) || this.areTasksCompatible(par1WrappedGoal, entry)) continue;
                this.theProfiler.m_7238_();
                return false;
            }
            if (!this.executingGoals.contains(entry) || entry.goal.m_6767_()) continue;
            this.theProfiler.m_7238_();
            return false;
        }
        this.theProfiler.m_7238_();
        return true;
    }

    private boolean areTasksCompatible(WrappedGoal e1, WrappedGoal e2) {
        EnumSet flags = e2.goal.m_7684_();
        return e1.goal.m_7684_().stream().noneMatch(flags::contains);
    }

    public void setLabel(String label) {
        this.currentLabel = label;
        this.drone.updateLabel();
    }

    public String getLabel() {
        Object object;
        Goal goal = this.currentGoal;
        if (goal instanceof DroneAIExternalProgram) {
            DroneAIExternalProgram ext = (DroneAIExternalProgram)goal;
            object = ext.getRunningAI().getLabel() + "/" + this.currentLabel;
        } else {
            object = this.currentLabel;
        }
        return object;
    }

    public List<IProgWidget> widgets() {
        return this.progWidgets;
    }

    public record WrappedGoal(int priority, Goal goal) {
    }
}

