/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import java.util.Objects;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;

public class EntityTrackOptions
extends IOptionPage.SimpleOptionPage<EntityTrackerClientHandler> {
    private EditBox textField;
    private WidgetButtonExtended warningButton;
    private int sendTimer = 0;

    public EntityTrackOptions(IGuiScreen screen, EntityTrackerClientHandler renderHandler) {
        super(screen, renderHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        gui.addWidget(ClientArmorRegistry.getInstance().makeStatMoveButton(30, 128, (IArmorUpgradeClientHandler<?>)this.getClientUpgradeHandler()));
        this.textField = new EditBox(gui.getFontRenderer(), 35, 75, 140, 10, (Component)Component.m_237119_());
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.textField.m_94144_(PneumaticArmorItem.getEntityFilter(Minecraft.m_91087_().f_91074_.m_6844_(EquipmentSlot.HEAD)));
        }
        this.textField.m_94151_(s -> {
            if (this.validateEntityFilter(this.textField.m_94155_())) {
                this.sendTimer = 5;
            }
        });
        gui.addWidget(this.textField);
        gui.setFocusedWidget((AbstractWidget)this.textField);
        this.warningButton = new WidgetButtonExtended(175, 57, 20, 20, (Component)Component.m_237119_());
        this.warningButton.setVisible(false);
        this.warningButton.f_93624_ = false;
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        gui.addWidget(this.warningButton);
        this.validateEntityFilter(this.textField.m_94155_());
    }

    @Override
    public void renderPost(GuiGraphics graphics, int x, int y, float partialTicks) {
        Font font = this.getGuiScreen().getFontRenderer();
        String string = I18n.m_118938_((String)"pneumaticcraft.gui.entityFilter", (Object[])new Object[0]);
        int n = this.textField.m_252907_();
        Objects.requireNonNull(font);
        graphics.m_280056_(font, string, 35, n - 9 - 2, -1, false);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(graphics, this.getGuiScreen().getScreen(), font, GuiUtils.xlateAndSplit("pneumaticcraft.gui.entityFilter.helpText", new Object[0]));
        }
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.f_93624_ = false;
            this.warningButton.setTooltipText((Component)Component.m_237119_());
            new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.f_93624_ = true;
            this.warningButton.setTooltipText((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.GOLD));
            return false;
        }
    }

    @Override
    public void tick() {
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("entityFilter", this.textField.m_94155_());
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlot.HEAD, tag, ((EntityTrackerClientHandler)this.getClientUpgradeHandler()).getID()));
        }
    }

    @Override
    public boolean displaySettingsHeader() {
        return true;
    }
}

