/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModuleMap<ModuleType extends TileModule<TileType>, TileType extends BlockEntity> {
    private final ObjectArrayList<ModuleType> modules;
    private final ObjectArrayList<TileType> tiles = ObjectArrayList.wrap((Object[])new BlockEntity[0]);
    private final LongArrayList poses = new LongArrayList();
    private final Long2IntLinkedOpenHashMap indexMap = new Long2IntLinkedOpenHashMap();

    public ModuleMap(ModuleType[] moduleArray) {
        this.indexMap.defaultReturnValue(-1);
        this.modules = ObjectArrayList.wrap((Object[])moduleArray);
    }

    public boolean addModule(ModuleType module) {
        BlockEntity tile = (BlockEntity)((TileModule)module).iface;
        long posLong = tile.m_58899_().m_121878_();
        int previousIndex = this.indexMap.put(posLong, this.modules.size());
        if (previousIndex != -1) {
            this.indexMap.put(posLong, previousIndex);
            TileModule oldModule = (TileModule)this.modules.set(previousIndex, module);
            this.tiles.set(previousIndex, (Object)tile);
            this.poses.set(previousIndex, posLong);
            return oldModule != module;
        }
        this.modules.add(module);
        this.tiles.add((Object)tile);
        this.poses.add(tile.m_58899_().m_121878_());
        return true;
    }

    public void addAll(ModuleMap<ModuleType, TileType> otherMap) {
        otherMap.forEachModule(this::addModule);
    }

    public boolean removeModule(ModuleType module) {
        BlockEntity tile = (BlockEntity)((TileModule)module).iface;
        long posLong = tile.m_58899_().m_121878_();
        int index = this.indexMap.remove(posLong);
        if (index == -1) {
            return false;
        }
        TileModule previousEndModule = (TileModule)this.modules.remove(this.modules.size() - 1);
        BlockEntity previousEndTile = (BlockEntity)this.tiles.remove(this.tiles.size() - 1);
        long previousEndPos = this.poses.removeLong(this.poses.size() - 1);
        if (index != this.modules.size()) {
            this.indexMap.put(previousEndPos, index);
            this.modules.set(index, (Object)previousEndModule);
            this.tiles.set(index, (Object)previousEndTile);
            this.poses.set(index, previousEndPos);
        }
        return true;
    }

    public boolean containsTile(TileType tile) {
        return this.containsPos(tile.m_58899_());
    }

    public boolean containsModule(ModuleType module) {
        return this.containsPos(((BlockEntity)((TileModule)module).iface).m_58899_());
    }

    public boolean containsPos(BlockPos pos) {
        return this.getModule(pos) != null;
    }

    public boolean containsPos(Vector3i pos) {
        return this.getModule((Vector3ic)pos) != null;
    }

    @Nullable
    public ModuleType getModule(int x, int y, int z) {
        int index = this.indexMap.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
        if (index == -1) {
            return null;
        }
        return (ModuleType)((TileModule)this.modules.get(index));
    }

    @Nullable
    public ModuleType getModule(BlockPos pos) {
        return this.getModule(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @Nullable
    public ModuleType getModule(Vector3ic pos) {
        return this.getModule(pos.x(), pos.y(), pos.z());
    }

    @Nullable
    public TileType getTile(int x, int y, int z) {
        int index = this.indexMap.get(BlockPos.m_121882_((int)x, (int)y, (int)z));
        if (index == -1) {
            return null;
        }
        return (TileType)((BlockEntity)this.tiles.get(index));
    }

    @Nullable
    public TileType getTile(BlockPos pos) {
        return this.getTile(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @Nullable
    public TileType getTile(Vector3ic pos) {
        return this.getTile(pos.x(), pos.y(), pos.z());
    }

    public void forEachPosAndModule(BiConsumer<BlockPos, ModuleType> consumer) {
        for (int i = 0; i < this.modules.size(); ++i) {
            TileModule module = (TileModule)this.modules.get(i);
            consumer.accept(((BlockEntity)module.iface).m_58899_(), module);
        }
    }

    public void forEachPosAndTile(BiConsumer<BlockPos, TileType> consumer) {
        this.forEachTile(tile -> consumer.accept(tile.m_58899_(), tile));
    }

    public void forEachTile(Consumer<TileType> consumer) {
        this.forEachModule(module -> consumer.accept((BlockEntity)module.iface));
    }

    public void forEachModule(Consumer<ModuleType> consumer) {
        for (int i = 0; i < this.modules.size(); ++i) {
            consumer.accept((TileModule)this.modules.get(i));
        }
    }

    public void forEachTileAndModule(BiConsumer<TileType, ModuleType> consumer) {
        for (int i = 0; i < this.modules.size(); ++i) {
            consumer.accept((BlockEntity)this.tiles.get(i), (TileModule)this.modules.get(i));
        }
    }

    public void forEachTileAndModuleAndPosLong(TileModulePosLong<ModuleType, TileType> consumer) {
        int size = this.modules.size();
        BlockEntity[] tileElements = (BlockEntity[])this.tiles.elements();
        TileModule[] moduleElements = (TileModule[])this.modules.elements();
        long[] posElements = this.poses.elements();
        if (tileElements.length < size || moduleElements.length < size || posElements.length < size) {
            throw new IllegalStateException("Arrays too short");
        }
        for (int i = 0; i < size; ++i) {
            consumer.accept(tileElements[i], moduleElements[i], posElements[i]);
        }
    }

    public void forEachPos(Consumer<BlockPos> consumer) {
        this.forEachModule(module -> consumer.accept(((BlockEntity)module.iface).m_58899_()));
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public int size() {
        return this.modules.size();
    }

    public TileType[] tileElements() {
        return (BlockEntity[])this.tiles.elements();
    }

    public ModuleType[] moduleElements() {
        return (TileModule[])this.modules.elements();
    }

    public long[] posElements() {
        return this.poses.elements();
    }

    @Nullable
    public ModuleType getOne() {
        return (ModuleType)((TileModule)this.modules.get(0));
    }

    public void clear() {
        this.modules.clear();
        this.poses.clear();
        this.tiles.clear();
        this.indexMap.clear();
    }

    public static interface TileModulePosLong<ModuleType extends TileModule<TileType>, TileType extends BlockEntity> {
        public void accept(TileType var1, ModuleType var2, long var3);
    }
}

