/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.parsers;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class ROBN {
    @Nullable
    public static Element parseROBN(List<Byte> robn) {
        try {
            Object robnObject = net.roguelogix.phosphophyllite.robn.ROBN.fromROBN(robn);
            if (robnObject instanceof Map) {
                Map map = (Map)robnObject;
                return ROBN.parseROBNMap(map);
            }
            return null;
        }
        catch (ClassCastException | IllegalArgumentException ignored) {
            return null;
        }
    }

    private static Element parseROBNMap(Map<String, Object> map) {
        Object val;
        Element.Type type = Element.Type.valueOf((String)map.get("type"));
        String name = (String)map.get("name");
        switch (type) {
            case String: {
                val = map.get("value");
                if (val instanceof String) break;
                throw new IllegalArgumentException();
            }
            case Number: {
                val = map.get("value");
                if (val instanceof Number) break;
                throw new IllegalArgumentException();
            }
            case Boolean: {
                val = map.get("value");
                if (val instanceof Boolean) break;
                throw new IllegalArgumentException();
            }
            case Array: 
            case Map: {
                int length = (Integer)map.get("length");
                Element[] array = new Element[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = ROBN.parseROBNMap((Map)map.get(Integer.toString(i)));
                }
                return new Element(type, null, name, array);
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + type);
            }
        }
        return new Element(type, null, name, val);
    }

    @Nullable
    public static ByteArrayList parseElement(Element element) {
        try {
            return net.roguelogix.phosphophyllite.robn.ROBN.toROBN(ROBN.parseElementInternal(element));
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static HashMap<String, Object> parseElementInternal(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", element.type.toString());
        if (element.name != null) {
            map.put("name", element.name);
        }
        switch (element.type) {
            case String: 
            case Number: 
            case Boolean: {
                map.put("value", element.value);
                break;
            }
            case Array: 
            case Map: {
                Element[] array = element.subArray;
                assert (array != null);
                map.put("length", array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(Integer.toString(i), ROBN.parseElementInternal(array[i]));
                }
                break;
            }
        }
        return map;
    }
}

