/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.common;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.MultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.common.IPersistentMultiblock;
import net.roguelogix.phosphophyllite.multiblock.modular.ICoreMultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface IPersistentMultiblockTile<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IValidatedMultiblockTile<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends TileModule<TileType>
    implements ICoreMultiblockTileModule<TileType, BlockType, ControllerType> {
        @Nullable
        CompoundTag controllerNBT;
        IValidatedMultiblock.AssemblyState lastAssemblyState = IValidatedMultiblock.AssemblyState.DISASSEMBLED;
        int expectedBlocks = 0;
        MultiblockTileModule<TileType, BlockType, ControllerType> multiblockModule = null;
        @Nullable
        IPersistentMultiblock.Module<TileType, BlockType, ControllerType> controllerPersistentModule;

        @OnModLoad
        public static void register() {
            ModuleRegistry.registerTileModule(IPersistentMultiblockTile.class, Module::new);
        }

        public Module(IModularTile iface) {
            super(iface);
        }

        @Override
        public void postModuleConstruction() {
            this.multiblockModule = ((IMultiblockTile)((BlockEntity)this.iface)).multiblockModule();
        }

        @Override
        public String saveKey() {
            return "persistent_multiblock";
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("last_assembly_state")) {
                this.lastAssemblyState = IValidatedMultiblock.AssemblyState.valueOf(nbt.m_128461_("last_assembly_state"));
            }
            if (nbt.m_128441_("expected_blocks")) {
                this.expectedBlocks = nbt.m_128451_("expected_blocks");
            }
            if (nbt.m_128441_("controller_data")) {
                this.controllerNBT = nbt.m_128469_("controller_data");
                return;
            }
            this.controllerNBT = null;
        }

        @Override
        public CompoundTag writeNBT() {
            if (this.controllerPersistentModule != null && this.controllerPersistentModule.isSaveDelegate((BlockEntity)this.iface) && this.controllerNBT == null) {
                this.controllerNBT = this.controllerPersistentModule.getNBT();
            }
            CompoundTag toReturn = new CompoundTag();
            toReturn.m_128359_("last_assembly_state", this.lastAssemblyState.toString());
            if (this.controllerNBT != null) {
                toReturn.m_128365_("controller_data", (Tag)this.controllerNBT);
            }
            return toReturn;
        }

        @Override
        public void aboutToUnloadDetach() {
            this.controllerNBT = null;
            this.writeNBT();
        }

        @Override
        public void onControllerChange() {
            ControllerType controller = this.multiblockModule.controller();
            if (controller == null) {
                this.controllerPersistentModule = null;
                return;
            }
            this.controllerPersistentModule = ((IPersistentMultiblock)controller).persistentModule();
        }
    }
}

