/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface ISidedMultipart
extends IModularTile {
    public TileModule<?> initialCoreModule();

    public static class SidedMultipartModule
    extends TileModule<ISidedMultipart> {
        @Nonnull
        TileModule<?> coreModule;
        final TileModule<?>[] sidedModules = new TileModule[6];

        @OnModLoad
        private static void onModLoad() {
            ModuleRegistry.registerTileModule(ISidedMultipart.class, SidedMultipartModule::new);
        }

        private SidedMultipartModule(ISidedMultipart iface) {
            super(iface);
            this.coreModule = iface.initialCoreModule();
        }

        public TileModule<?> getSideModule(@Nullable Direction side) {
            if (side == null) {
                return this.coreModule;
            }
            TileModule<?> module = this.sidedModules[side.m_122411_()];
            if (module == null) {
                return this.coreModule;
            }
            return module;
        }

        public <T> T getSideModule(@Nullable Direction side, Class<T> moduleType) {
            return (T)this.getSideModule(side);
        }

        public void setSideModule(@Nullable TileModule<?> module, @Nullable Direction side) {
            if (side == null) {
                if (module != null) {
                    this.coreModule = module;
                }
                return;
            }
            this.sidedModules[side.m_122411_()] = module;
        }

        @Override
        public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
            return this.getSideModule(side).capability(cap, side);
        }

        @Override
        public void onAdded() {
            this.coreModule.onAdded();
            for (TileModule<?> sidedModule : this.sidedModules) {
                if (sidedModule == null) continue;
                sidedModule.onAdded();
            }
        }

        @Override
        public void onRemoved(boolean chunkUnload) {
            this.coreModule.onRemoved(chunkUnload);
            for (TileModule<?> sidedModule : this.sidedModules) {
                if (sidedModule == null) continue;
                sidedModule.onRemoved(chunkUnload);
            }
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("core")) {
                CompoundTag subNBT = nbt.m_128469_("core");
                this.coreModule.readNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.m_128441_(value.toString())) continue;
                CompoundTag subNBT = nbt.m_128469_(value.toString());
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null) {
                    PhosphophylliteTile.MODULE_LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.iface + " : " + ((ISidedMultipart)this.iface).as(BlockEntity.class).m_58900_());
                    continue;
                }
                module.readNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundTag writeNBT() {
            CompoundTag nbt = null;
            CompoundTag subNBT = this.coreModule.writeNBT();
            if (subNBT != null) {
                nbt = new CompoundTag();
                nbt.m_128365_("core", (Tag)subNBT);
            }
            for (Direction value : Direction.values()) {
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null || (subNBT = module.writeNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundTag();
                }
                nbt.m_128365_(value.toString(), (Tag)subNBT);
            }
            return nbt;
        }

        @Override
        public void handleDataNBT(CompoundTag nbt) {
            if (nbt.m_128441_("core")) {
                CompoundTag subNBT = nbt.m_128469_("core");
                this.coreModule.handleDataNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.m_128441_(value.toString())) continue;
                CompoundTag subNBT = nbt.m_128469_(value.toString());
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null) {
                    PhosphophylliteTile.MODULE_LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.iface + " : " + ((ISidedMultipart)this.iface).as(BlockEntity.class).m_58900_());
                    continue;
                }
                module.handleDataNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundTag getDataNBT() {
            CompoundTag nbt = null;
            CompoundTag subNBT = this.coreModule.getDataNBT();
            if (subNBT != null) {
                nbt = new CompoundTag();
                nbt.m_128365_("core", (Tag)subNBT);
            }
            for (Direction value : Direction.values()) {
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null || (subNBT = module.getDataNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundTag();
                }
                nbt.m_128365_(value.toString(), (Tag)subNBT);
            }
            return nbt;
        }

        @Override
        public void handleUpdateNBT(CompoundTag nbt) {
            if (nbt.m_128441_("core")) {
                CompoundTag subNBT = nbt.m_128469_("core");
                this.coreModule.handleUpdateNBT(subNBT);
            }
            for (Direction value : Direction.values()) {
                if (!nbt.m_128441_(value.toString())) continue;
                CompoundTag subNBT = nbt.m_128469_(value.toString());
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null) {
                    PhosphophylliteTile.MODULE_LOGGER.warn("Attempting to read NBT to side module that doesnt exist! " + this.iface + " : " + ((ISidedMultipart)this.iface).as(BlockEntity.class).m_58900_());
                    continue;
                }
                module.handleUpdateNBT(subNBT);
            }
        }

        @Override
        @Nullable
        public CompoundTag getUpdateNBT() {
            CompoundTag nbt = null;
            CompoundTag subNBT = this.coreModule.getUpdateNBT();
            if (subNBT != null) {
                nbt = new CompoundTag();
                nbt.m_128365_("core", (Tag)subNBT);
            }
            for (Direction value : Direction.values()) {
                TileModule<?> module = this.sidedModules[value.m_122411_()];
                if (module == null || (subNBT = module.getUpdateNBT()) == null) continue;
                if (nbt == null) {
                    nbt = new CompoundTag();
                }
                nbt.m_128365_(value.toString(), (Tag)subNBT);
            }
            return nbt;
        }

        @Override
        @Nullable
        public DebugInfo getDebugInfo() {
            return null;
        }

        @Override
        public String saveKey() {
            return "PhosphophylliteMultipartTileModule";
        }
    }
}

