/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.fluids;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.fluids.PhosphophylliteFluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidHandlerWrapper
implements IPhosphophylliteFluidHandler {
    IFluidHandler handler;
    PhosphophylliteFluidStack scratchStack = new PhosphophylliteFluidStack();

    public static IPhosphophylliteFluidHandler wrap(IFluidHandler handler) {
        if (handler instanceof IPhosphophylliteFluidHandler) {
            return (IPhosphophylliteFluidHandler)handler;
        }
        return new FluidHandlerWrapper(handler);
    }

    private FluidHandlerWrapper(IFluidHandler handler) {
        this.handler = handler;
    }

    @Override
    public int tankCount() {
        return this.handler.getTanks();
    }

    @Override
    public long tankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    @Override
    public Fluid fluidTypeInTank(int tank) {
        return this.handler.getFluidInTank(tank).getRawFluid();
    }

    @Override
    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        return this.handler.getFluidInTank(tank).getTag();
    }

    @Override
    public long fluidAmountInTank(int tank) {
        return this.handler.getFluidInTank(tank).getAmount();
    }

    @Override
    public boolean fluidValidForTank(int tank, Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            return false;
        }
        this.scratchStack.setFluid(fluid);
        this.scratchStack.setAmount(0);
        return this.handler.isFluidValid(tank, (FluidStack)this.scratchStack);
    }

    @Override
    public long fill(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (fluid == Fluids.f_76191_) {
            return 0L;
        }
        this.scratchStack.setFluid(fluid);
        this.scratchStack.setTag(tag);
        this.scratchStack.setAmount(amount);
        return this.handler.fill((FluidStack)this.scratchStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public long drain(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (fluid == Fluids.f_76191_) {
            return 0L;
        }
        this.scratchStack.setFluid(fluid);
        this.scratchStack.setTag(tag);
        this.scratchStack.setAmount(amount);
        FluidStack drained = this.handler.drain((FluidStack)this.scratchStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return drained.getAmount();
    }
}

