/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.config.spec.SpecValueNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class SpecBoolNode
extends SpecValueNode {
    public final boolean defaultValue = (Boolean)this.currentValueObject();

    SpecBoolNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
    }

    @Override
    public String defaultValueAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String currentValueAsString() {
        return String.valueOf(this.currentValueObject());
    }

    @Override
    public void writeFromString(String string) {
        this.writeObject(Boolean.parseBoolean(string));
    }

    @Override
    public boolean isValueValid(String valueString) {
        return valueString.equalsIgnoreCase("true") || valueString.equalsIgnoreCase("false");
    }

    @Override
    public void writeDefault() {
        this.writeObject(this.defaultValue);
    }

    @Override
    public Element generateDefaultElement() {
        return new Element(Element.Type.Boolean, this.generateComment(), this.name, this.defaultValue);
    }

    @Override
    public Element generateCurrentElement() {
        return new Element(Element.Type.Boolean, this.generateComment(), this.name, this.currentValueObject());
    }

    @Override
    public Element generateSyncElement() {
        return new Element(Element.Type.Boolean, null, this.name, this.currentValueObject());
    }

    @Override
    public String generateComment() {
        StringBuilder comment = new StringBuilder(this.baseComment);
        if (comment.length() != 0) {
            comment.append('\n');
        }
        comment.append("Default: ");
        comment.append(this.defaultValue);
        return comment.toString();
    }

    @Override
    public Element correctToValidState(Element element) {
        if (element.type != Element.Type.Boolean || !(element.value instanceof Boolean)) {
            return this.generateDefaultElement();
        }
        return new Element(Element.Type.Boolean, this.generateComment(), this.name, element.asBool());
    }

    @Override
    public void writeElement(Element element) {
        this.writeObject(element.asBool());
    }
}

