/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.config.ConfigFormat;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.parsers.Element;

public class ConfigRegistration {
    public final ConfigType configType;
    public final Object rootConfigObject;
    public final SpecObjectNode rootConfigSpecNode;
    public final String modName;
    public final String comment;
    public final ConfigFormat fileFormat;
    public final File baseFile;
    public final File writeFile;
    private final List<Runnable> preLoadCallbacks;
    private final List<Runnable> postLoadCallbacks;
    @Nullable
    private Element savedLocalConfig;

    ConfigRegistration(Object rootConfigObject, String modName, String name, String folder, String comment, ConfigFormat format, ConfigType configType, ConfigType rootLevelDefaultType, boolean rootLevelReloadableDefault, List<Runnable> preLoadCallbacks, List<Runnable> postLoadCallbacks) {
        this.configType = configType;
        this.rootConfigObject = rootConfigObject;
        ConfigOptionsDefaults defaultConfigOptions = new ConfigOptionsDefaults(rootLevelDefaultType, false, false, rootLevelReloadableDefault);
        this.rootConfigSpecNode = new SpecObjectNode(rootConfigObject, comment, configType, defaultConfigOptions);
        this.modName = modName;
        this.comment = comment;
        this.fileFormat = format;
        this.baseFile = new File("config/" + folder + "/" + name + "-" + configType.toString().toLowerCase(Locale.US));
        this.writeFile = new File(this.baseFile + "." + format.toString().toLowerCase(Locale.US));
        this.preLoadCallbacks = new ObjectArrayList(preLoadCallbacks);
        this.postLoadCallbacks = new ObjectArrayList(postLoadCallbacks);
    }

    public void loadLocalConfigFile(boolean reload) {
        Element reloadTrimmed;
        this.preLoadCallbacks.forEach(Runnable::run);
        this.savedLocalConfig = null;
        Pair<File, ConfigFormat> foundFile = ConfigRegistration.findFile(this.baseFile, this.fileFormat);
        if (foundFile == null) {
            this.generateFile(reload);
            this.postLoadCallbacks.forEach(Runnable::run);
            return;
        }
        Element fileElement = ConfigRegistration.readFile((File)foundFile.getFirst(), (ConfigFormat)((Object)foundFile.getSecond()));
        if (!((File)foundFile.getFirst()).equals(this.writeFile)) {
            ConfigRegistration.writeFile(null, (File)foundFile.getFirst(), (ConfigFormat)((Object)foundFile.getSecond()));
        }
        if (fileElement == null) {
            this.generateFile(reload);
            this.postLoadCallbacks.forEach(Runnable::run);
            return;
        }
        Element orderCorrectedTree = this.rootConfigSpecNode.correctElementOrder(fileElement);
        Element valueCorrectedTree = this.rootConfigSpecNode.correctToValidState(orderCorrectedTree);
        if (valueCorrectedTree == null) {
            this.generateFile(reload);
            this.postLoadCallbacks.forEach(Runnable::run);
            return;
        }
        Element element = reloadTrimmed = reload ? this.rootConfigSpecNode.trimToReloadable(valueCorrectedTree) : valueCorrectedTree;
        if (reloadTrimmed != null) {
            this.rootConfigSpecNode.writeElement(reloadTrimmed);
        }
        Element regeneratedTree = this.rootConfigSpecNode.regenerateMissingElements(valueCorrectedTree);
        ConfigRegistration.writeFile(regeneratedTree, this.writeFile, this.fileFormat);
        this.postLoadCallbacks.forEach(Runnable::run);
    }

    private void generateFile(boolean reload) {
        if (!reload) {
            this.rootConfigSpecNode.writeDefault();
        }
        ConfigRegistration.writeFile(this.rootConfigSpecNode.generateCurrentElement(), this.writeFile, this.fileFormat);
    }

    public void loadRemoteConfig(Element elementTree, boolean reload) {
        if (this.configType != ConfigType.COMMON) {
            return;
        }
        this.preLoadCallbacks.forEach(Runnable::run);
        if (this.savedLocalConfig == null) {
            this.savedLocalConfig = this.rootConfigSpecNode.generateSyncElement();
        }
        if ((elementTree = this.rootConfigSpecNode.removeUnknownElements(elementTree)) == null) {
            elementTree = this.rootConfigSpecNode.generateSyncElement();
        }
        if ((elementTree = this.rootConfigSpecNode.correctToValidState(elementTree)) == null) {
            elementTree = this.rootConfigSpecNode.generateSyncElement();
        }
        if (reload) {
            elementTree = this.rootConfigSpecNode.trimToReloadable(elementTree);
        }
        if (elementTree == null) {
            this.postLoadCallbacks.forEach(Runnable::run);
            return;
        }
        this.rootConfigSpecNode.writeElement(elementTree);
        this.postLoadCallbacks.forEach(Runnable::run);
    }

    public void unloadRemoteConfig() {
        if (this.configType != ConfigType.COMMON) {
            return;
        }
        if (this.savedLocalConfig == null) {
            return;
        }
        this.rootConfigSpecNode.writeElement(this.savedLocalConfig);
        this.savedLocalConfig = null;
    }

    public boolean isLocalLoaded() {
        return this.savedLocalConfig == null;
    }

    private static void writeFile(@Nullable Element tree, File file, ConfigFormat format) {
        if (tree == null) {
            Path path = Paths.get(String.valueOf(file), new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        String writeString = format.parse(tree);
        try {
            file.getParentFile().mkdirs();
            Files.write(Paths.get(String.valueOf(file), new String[0]), writeString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            ConfigManager.LOGGER.error("Failed to write config file " + file);
            e.printStackTrace();
        }
    }

    @Nullable
    private static Element readFile(File file, ConfigFormat format) {
        String fileContents;
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(String.valueOf(file), new String[0])));
        }
        catch (IOException e) {
            ConfigManager.LOGGER.error("Failed to read config file " + file);
            return null;
        }
        Element element = format.parse(fileContents);
        if (element == null) {
            ConfigManager.LOGGER.error("Failed to parse config file " + file);
        }
        return element;
    }

    @Nullable
    private static Pair<File, ConfigFormat> findFile(File baseFile, ConfigFormat expectedFormat) {
        File file = null;
        ConfigFormat format = null;
        for (ConfigFormat value : ConfigFormat.values()) {
            File fullFile = new File(baseFile + "." + value.toString().toLowerCase(Locale.US));
            if (!fullFile.exists()) continue;
            if (file != null) {
                if (expectedFormat != value) continue;
                file = fullFile;
                format = value;
                continue;
            }
            format = value;
            file = fullFile;
        }
        if (file == null) {
            return null;
        }
        return new Pair(file, format);
    }

    public boolean isEmpty() {
        return this.rootConfigSpecNode.subNodeList.size() == 1;
    }
}

