/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.blackholes;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.energy.IEnergyTile;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyHandler;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class PowerBlackHoleTile
extends PhosphophylliteTile
implements IEnergyTile {
    @RegisterTile(value="power_black_hole")
    public static final BlockEntityType.BlockEntitySupplier<PowerBlackHoleTile> SUPPLIER = new RegisterTile.Producer<PowerBlackHoleTile>(PowerBlackHoleTile::new);
    private static final Direction[] directions = Direction.values();
    private final ObjectArrayList<LazyOptional<IPhosphophylliteEnergyHandler>> handlers = new ObjectArrayList();
    private LazyOptional<IPhosphophylliteEnergyHandler> energyHandler;
    private long receivedLastTick;
    private boolean doPull;
    private boolean allowPush;

    public PowerBlackHoleTile(BlockEntityType<?> TYPE, BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.handlers.add((Object)LazyOptional.empty());
        this.energyHandler = LazyOptional.empty();
        this.receivedLastTick = 0L;
        this.doPull = false;
        this.allowPush = true;
        this.rotateCapability(null);
    }

    @Override
    public LazyOptional<IPhosphophylliteEnergyHandler> energyHandler() {
        return this.energyHandler;
    }

    public void tick() {
        assert (this.f_58857_ != null);
        this.receivedLastTick = 0L;
        if (this.doPull) {
            this.handlers.forEach(cap -> cap.ifPresent(this::sendEnergy));
        }
    }

    private void sendEnergy(IPhosphophylliteEnergyHandler handler) {
        long received = handler.extractEnergy(Long.MAX_VALUE, false);
        if (this.receivedLastTick + received < this.receivedLastTick) {
            this.receivedLastTick = Long.MAX_VALUE;
            return;
        }
        this.receivedLastTick += received;
    }

    public void rotateCapability(@Nullable Player player) {
        this.energyHandler.invalidate();
        this.energyHandler = LazyOptional.of(() -> new IPhosphophylliteEnergyHandler(){

            private void ensureValid() {
                if (!Phosphophyllite.CONFIG.debugMode) {
                    return;
                }
                if (!PowerBlackHoleTile.this.energyHandler.isPresent()) {
                    throw new IllegalStateException("Attempt to use capability when not present");
                }
                if (PowerBlackHoleTile.this.energyHandler.orElse((Object)this) != this) {
                    throw new IllegalStateException("Attempt to use capability after invalidate");
                }
            }

            @Override
            public long insertEnergy(long maxInsert, boolean simulate) {
                this.ensureValid();
                if (maxInsert < 0L) {
                    if (Phosphophyllite.CONFIG.debugMode) {
                        throw new IllegalStateException("Something tried to insert negative power");
                    }
                    return 0L;
                }
                if (!simulate) {
                    if (PowerBlackHoleTile.this.receivedLastTick + maxInsert < PowerBlackHoleTile.this.receivedLastTick) {
                        PowerBlackHoleTile.this.receivedLastTick = Long.MAX_VALUE;
                        return maxInsert;
                    }
                    PowerBlackHoleTile.this.receivedLastTick += maxInsert;
                }
                return maxInsert;
            }

            @Override
            public long extractEnergy(long maxExtract, boolean simulate) {
                this.ensureValid();
                if (maxExtract < 0L) {
                    if (Phosphophyllite.CONFIG.debugMode) {
                        throw new IllegalStateException("Something tried to insert negative power");
                    }
                    return 0L;
                }
                return 0L;
            }

            @Override
            public long energyStored() {
                this.ensureValid();
                return 0L;
            }

            @Override
            public long maxEnergyStored() {
                this.ensureValid();
                return Long.MAX_VALUE;
            }
        });
        if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)"Capability invalidated"));
        }
    }

    public void nextOption(Player player) {
        if (this.doPull) {
            if (this.allowPush) {
                this.allowPush = false;
            } else {
                this.allowPush = true;
                this.doPull = false;
            }
        } else {
            this.doPull = true;
            this.allowPush = true;
        }
        if (player.m_7578_()) {
            player.m_213846_((Component)Component.m_237113_((String)("doPull: " + this.doPull + ", allowPush: " + this.allowPush)));
        }
    }

    @Override
    public void onAdded() {
        for (Direction direction : directions) {
            this.updateCapability(direction, null, this.m_58899_());
        }
    }

    @Override
    public void onRemoved(boolean chunkUnload) {
        this.energyHandler.invalidate();
    }

    @Override
    protected void readNBT(CompoundTag compound) {
        this.doPull = compound.m_128471_("doPull");
        this.allowPush = compound.m_128471_("allowPush");
    }

    @Override
    protected CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("doPull", this.doPull);
        tag.m_128379_("allowPush", this.allowPush);
        return tag;
    }

    @Override
    @Nonnull
    public DebugInfo getDebugInfo() {
        return super.getDebugInfo().add("ReceivedLastTick: " + this.receivedLastTick).add("DoPull " + this.doPull).add("AllowPush " + this.allowPush);
    }

    public void updateCapability(Direction updateDirection, @Nullable Block oldBlock, BlockPos updatePos) {
        int index = updateDirection.ordinal();
        LazyOptional capability = (LazyOptional)this.handlers.get(index);
        if (Phosphophyllite.CONFIG.debugMode && capability.isPresent() && oldBlock != null) {
            assert (this.f_58857_ != null);
            BlockState currentBlockState = this.f_58857_.m_8055_(updatePos);
            if (currentBlockState.m_60734_() != oldBlock) {
                Phosphophyllite.LOGGER.warn("Block updated from " + ForgeRegistries.BLOCKS.getKey((Object)oldBlock) + " without invalidating capability");
                this.handlers.set(index, (Object)LazyOptional.empty());
            }
        }
        if (!capability.isPresent()) {
            this.handlers.set(index, (Object)this.findEnergyCapability(updateDirection));
        }
    }
}

