/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit;

import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.client.gui.GuiHelper;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemModes;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class BookOfCallingManageMachineItem
extends BookOfCallingItem {
    public BookOfCallingManageMachineItem(Item.Properties properties, String translationKeyBase) {
        super(properties, translationKeyBase, spirit -> spirit.getJob().orElse(null) instanceof ManageMachineJob);
    }

    @Override
    public InteractionResult handleItemMode(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing) {
        MachineReference machine;
        ItemMode itemMode = this.getCurrentItemMode(stack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!world.f_46443_) {
            if (itemMode == ItemModes.SET_EXTRACT && blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) {
                return this.setSpiritManagedMachineExtractLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        } else if (Objects.requireNonNull(itemMode) == ItemModes.SET_MANAGED_MACHINE && blockEntity != null && BlockEntityUtil.hasCapabilityOnAnySide(blockEntity, ForgeCapabilities.ITEM_HANDLER) && (machine = ItemNBTUtil.getManagedMachine(stack)) != null) {
            GuiHelper.openBookOfCallingManagedMachineGui(machine.insertFacing, machine.extractFacing, machine.customName);
        }
        return super.handleItemMode(player, world, pos, stack, facing);
    }

    public boolean setSpiritManagedMachineExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            BlockEntity extractBlockEntity = world.m_7702_(pos);
            if (boundSpirit.isPresent() && extractBlockEntity != null) {
                SpiritJob spiritJob;
                if (boundSpirit.get().getJob().isPresent() && (spiritJob = boundSpirit.get().getJob().get()) instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)spiritJob;
                    if (manageMachine.getManagedMachine() == null) {
                        player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString())}), true);
                        return true;
                    }
                    BlockEntity oldManagedMachineBlockEntity = manageMachine.getManagedMachineBlockEntity();
                    MachineReference newReference = MachineReference.from(extractBlockEntity, oldManagedMachineBlockEntity != null ? oldManagedMachineBlockEntity : extractBlockEntity);
                    newReference.extractFacing = face;
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().extractGlobalPos.equals(newReference.extractGlobalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().extractRegistryName = newReference.extractRegistryName;
                        manageMachine.getManagedMachine().extractFacing = newReference.extractFacing;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                    player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName), face.m_7912_()}), true);
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    @Override
    public List<ItemMode> getItemModes() {
        return Arrays.asList(ItemModes.SET_MANAGED_MACHINE, ItemModes.SET_EXTRACT, ItemModes.SET_STORAGE_CONTROLLER);
    }
}

