/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.entries.ContentBookEntry;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.bookstate.visual.EntryVisualState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SaveEntryStateMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "save_entry_state");
    public BookEntry entry;
    public int openPagesIndex;

    public SaveEntryStateMessage(ContentBookEntry entry, int openPagesIndex) {
        this.entry = entry;
        this.openPagesIndex = openPagesIndex;
    }

    public SaveEntryStateMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.entry.getBook().getId());
        buf.m_130085_(this.entry.getId());
        buf.m_130130_(this.openPagesIndex);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entry = BookDataManager.get().getBook(buf.m_130281_()).getEntry(buf.m_130281_());
        this.openPagesIndex = buf.m_130242_();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        EntryVisualState currentState = BookVisualStateManager.get().getEntryStateFor((Player)player, this.entry);
        currentState.openPagesIndex = this.openPagesIndex;
        BookVisualStateManager.get().setEntryStateFor(player, this.entry, currentState);
        BookVisualStateManager.get().syncFor(player);
    }
}

