/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookCategoryHasVisibleEntriesCondition
extends BookCondition {
    protected ResourceLocation categoryId;

    public BookCategoryHasVisibleEntriesCondition(Component tooltip, ResourceLocation categoryId) {
        super(tooltip);
        this.categoryId = categoryId;
    }

    public static BookCategoryHasVisibleEntriesCondition fromJson(JsonObject json) {
        ResourceLocation categoryId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"category_id"));
        MutableComponent tooltip = Component.m_237110_((String)"tooltip.modonomicon..condition.has_visible_entries", (Object[])new Object[]{categoryId});
        return new BookCategoryHasVisibleEntriesCondition((Component)tooltip, categoryId);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buffer.m_130083_(this.tooltip);
        }
        buffer.m_130085_(this.categoryId);
    }

    public static BookCategoryHasVisibleEntriesCondition fromNetwork(FriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? buffer.m_130238_() : null;
        ResourceLocation entryId = buffer.m_130281_();
        return new BookCategoryHasVisibleEntriesCondition(tooltip, entryId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.CATEGORY_HAS_VISIBLE_ENTRIES;
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        BookCategory category = context.book.getCategory(this.categoryId);
        if (category == null) {
            throw new IllegalArgumentException("Category with id " + this.categoryId + " not found in book " + context.getBook().getId() + "for BookCategoryHasVisibleEntriesCondition. This happened while trying to unlock " + context);
        }
        if (category.getEntries().isEmpty()) {
            return false;
        }
        for (BookEntry entry : category.getEntries().values()) {
            if (!entry.getEntryDisplayState(player).isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltip == null && context instanceof BookConditionEntryContext) {
            BookConditionEntryContext entryContext = (BookConditionEntryContext)context;
            this.tooltip = Component.m_237110_((String)"tooltip.modonomicon..condition.has_visible_entries", (Object[])new Object[]{Component.m_237115_((String)entryContext.getBook().getEntry(this.categoryId).getName())});
        }
        return super.getTooltip(player, context);
    }
}

