/*
 * Decompiled with CFR 0.152.
 */
package com.liberty.mekanism.addon.adastra.datagen;

import com.liberty.mekanism.addon.adastra.OreRegister;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mekanism.common.resource.ore.OreType;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;

public class ModLanguageProviders {
    private static final String MOON = "moon";
    private static final String MARS = "mars";
    private static final String MERCURY = "mercury";
    private static final String VENUS = "venus";
    private static final String GLACIO = "glacio";

    public static List<LanguageProvider> getLanguageProviders(PackOutput packOutput) {
        return Arrays.stream(SupportedLocale.values()).map(loc -> ModLanguageProviders.getLanguageProvider(packOutput, loc)).toList();
    }

    public static LanguageProvider getLanguageProvider(PackOutput packOutput, SupportedLocale locale) {
        Map<RegistryObject, List> oreNames = OreRegister.BLOCKS.getEntries().stream().collect(Collectors.toMap(k -> k, v -> Arrays.stream(v.getId().m_135815_().split("_")).toList()));
        final Consumer<LanguageProvider> genLocale = switch (locale) {
            default -> throw new IncompatibleClassChangeError();
            case SupportedLocale.EN_US -> l -> oreNames.forEach((k, v) -> l.add((Block)k.get(), v.stream().map(StringUtils::capitalize).collect(Collectors.joining(" "))));
            case SupportedLocale.JA_JP -> l -> oreNames.forEach((k, v) -> {
                String planet = switch ((String)v.get(0)) {
                    case MOON -> "\u6708";
                    case MARS -> "\u706b\u661f";
                    case MERCURY -> "\u6c34\u661f";
                    case VENUS -> "\u91d1\u661f";
                    case GLACIO -> "\u30b0\u30ec\u30fc\u30b7\u30e3\u30fc";
                    default -> (String)v.get(0);
                };
                String oreName = switch (Objects.requireNonNull((OreType)OreRegister.MOD_ORE_IDS.get((Object)k.getId()))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OreType.TIN -> "\u932b";
                    case OreType.OSMIUM -> "\u30aa\u30b9\u30df\u30a6\u30e0";
                    case OreType.LEAD -> "\u925b";
                    case OreType.URANIUM -> "\u30a6\u30e9\u30f3";
                    case OreType.FLUORITE -> "\u86cd\u77f3";
                };
                l.add((Block)k.get(), String.format("%s%s%s", planet, oreName, "\u9271\u77f3"));
            });
            case SupportedLocale.KO_KR -> l -> oreNames.forEach((k, v) -> {
                String planet = switch ((String)v.get(0)) {
                    case MOON -> "\ub2ec";
                    case MARS -> "\ud654\uc131";
                    case MERCURY -> "\uc218\uc131";
                    case VENUS -> "\uae08\uc131";
                    case GLACIO -> "\uae00\ub77c\uc2dc\uc624";
                    default -> (String)v.get(0);
                };
                String oreName = switch (Objects.requireNonNull((OreType)OreRegister.MOD_ORE_IDS.get((Object)k.getId()))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OreType.TIN -> "\uc8fc\uc11d";
                    case OreType.OSMIUM -> "\uc624\uc2a4\ubbb4";
                    case OreType.LEAD -> "\ub0a9";
                    case OreType.URANIUM -> "\uc6b0\ub77c\ub284";
                    case OreType.FLUORITE -> "\ud615\uc11d";
                };
                l.add((Block)k.get(), String.format("%s %s %s", planet, oreName, "\uad11\uc11d"));
            });
            case SupportedLocale.ZH_CN -> l -> oreNames.forEach((k, v) -> {
                String planet = switch ((String)v.get(0)) {
                    case MOON -> "\u6708";
                    case MARS -> "\u706b\u661f";
                    case MERCURY -> "\u6c34\u661f";
                    case VENUS -> "\u91d1\u661f";
                    case GLACIO -> "\u971c";
                    default -> (String)v.get(0);
                };
                String oreName = switch (Objects.requireNonNull((OreType)OreRegister.MOD_ORE_IDS.get((Object)k.getId()))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OreType.TIN -> "\u9521";
                    case OreType.OSMIUM -> "\u9507";
                    case OreType.LEAD -> "\u94c5";
                    case OreType.URANIUM -> "\u94c0";
                    case OreType.FLUORITE -> "\u6c1f\u77f3";
                };
                l.add((Block)k.get(), String.format("%s%s%s", planet, oreName, "\u77ff\u77f3"));
            });
            case SupportedLocale.ZH_TW -> l -> oreNames.forEach((k, v) -> {
                String planet = switch ((String)v.get(0)) {
                    case MOON -> "\u6708\u7403";
                    case MARS -> "\u706b\u661f";
                    case MERCURY -> "\u6c34\u661f";
                    case VENUS -> "\u91d1\u661f";
                    case GLACIO -> "\u971c";
                    default -> (String)v.get(0);
                };
                String oreName = switch (Objects.requireNonNull((OreType)OreRegister.MOD_ORE_IDS.get((Object)k.getId()))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OreType.TIN -> "\u932b";
                    case OreType.OSMIUM -> "\u92e8";
                    case OreType.LEAD -> "\u925b";
                    case OreType.URANIUM -> "\u923e";
                    case OreType.FLUORITE -> "\u87a2\u77f3";
                };
                l.add((Block)k.get(), String.format("%s%s%s", planet, oreName, "\u7926"));
            });
            case SupportedLocale.FR_FR -> l -> oreNames.forEach((k, v) -> {
                String planet = switch ((String)v.get(0)) {
                    case MOON -> "Lunaire";
                    case MARS -> "Martienne";
                    case MERCURY -> "Mercurienne";
                    case VENUS -> "Venusienne";
                    case GLACIO -> "Glacienne";
                    default -> (String)v.get(0);
                };
                String oreName = switch (Objects.requireNonNull((OreType)OreRegister.MOD_ORE_IDS.get((Object)k.getId()))) {
                    default -> throw new IncompatibleClassChangeError();
                    case OreType.TIN -> "d'\u00e9tain";
                    case OreType.OSMIUM -> "d'osmium";
                    case OreType.LEAD -> "de plomb";
                    case OreType.URANIUM -> "d'uranium";
                    case OreType.FLUORITE -> "de fluorite";
                };
                l.add((Block)k.get(), String.format("Minerais %s des %s", oreName, planet));
            });
        };
        return new LanguageProvider(packOutput, "mekanismaaa", locale.localeCode){

            protected void addTranslations() {
                this.add("itemGroup.mekanismaaa.ores", "Mekanism: Ad Astra Ores");
                genLocale.accept(this);
            }
        };
    }

    public static enum SupportedLocale {
        EN_US("en_us"),
        JA_JP("ja_jp"),
        KO_KR("ko_kr"),
        ZH_CN("zh_cn"),
        ZH_TW("zh_tw"),
        FR_FR("fr_fr");

        private final String localeCode;

        private SupportedLocale(String localeCode) {
            this.localeCode = localeCode;
        }
    }
}

