/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.typed.Type;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractLabel<P extends AbstractLabel<P>>
extends AbstractWidget<P> {
    public static final String TYPE_LABEL = "label";
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGN = HorizontalAlignment.ALIGN_CENTER;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGN = VerticalAlignment.ALIGN_CENTER;
    public static final boolean DEFAULT_DYNAMIC = false;
    private String text;
    private Integer color = null;
    private Integer disabledColor = null;
    private HorizontalAlignment horizontalAlignment = DEFAULT_HORIZONTAL_ALIGN;
    private VerticalAlignment verticalAlignment = DEFAULT_VERTICAL_ALIGN;
    private boolean dynamic = false;
    private int txtDx = 0;
    private int txtDy = 0;
    private ResourceLocation image = null;
    private int u;
    private int v;
    private int iw;
    private int ih;

    public ResourceLocation getImage() {
        return this.image;
    }

    public P image(ResourceLocation image, int u, int v, int iw, int ih) {
        this.image = image;
        this.u = u;
        this.v = v;
        this.iw = iw;
        this.ih = ih;
        return (P)((AbstractLabel)this.getThis());
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public P dynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return (P)((AbstractLabel)this.getThis());
    }

    @Override
    public int getDesiredWidth() {
        int w = super.getDesiredWidth();
        if (this.dynamic) {
            return w;
        }
        if (w == -1) {
            w = this.mc.f_91062_.m_92895_(this.text) + 6;
        }
        return w;
    }

    @Override
    public int getDesiredHeight() {
        int h = super.getDesiredHeight();
        if (this.dynamic) {
            return h;
        }
        if (h == -1) {
            Objects.requireNonNull(this.mc.f_91062_);
            h = 9 + 2;
        }
        return h;
    }

    public String getText() {
        return this.text;
    }

    public P text(String text) {
        this.text = text;
        return (P)((AbstractLabel)this.getThis());
    }

    public P textOffset(int ox, int oy) {
        this.txtDx = ox;
        this.txtDy = oy;
        return (P)((AbstractLabel)this.getThis());
    }

    public int getColor() {
        return this.color == null ? StyleConfig.colorTextNormal : this.color;
    }

    public P color(int color) {
        this.color = color;
        return (P)((AbstractLabel)this.getThis());
    }

    public int getDisabledColor() {
        return this.disabledColor == null ? StyleConfig.colorTextDisabled : this.disabledColor;
    }

    public P disabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        return (P)((AbstractLabel)this.getThis());
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public P horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (P)((AbstractLabel)this.getThis());
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public P verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return (P)((AbstractLabel)this.getThis());
    }

    @Override
    public void draw(Screen gui, GuiGraphics graphics, int x, int y) {
        this.drawOffset(gui, graphics, x, y, 0, 0);
    }

    public void drawOffset(Screen gui, GuiGraphics graphics, int x, int y, int offsetx, int offsety) {
        if (!this.visible) {
            return;
        }
        super.draw(gui, graphics, x, y);
        int dx = this.calculateHorizontalOffset() + offsetx + this.txtDx;
        int dy = this.calculateVerticalOffset() + offsety + this.txtDy;
        if (this.image != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int xx = x + this.bounds.x + (this.bounds.width - this.iw) / 2;
            int yy = y + this.bounds.y + (this.bounds.height - this.ih) / 2;
            graphics.m_280218_(this.image, xx, yy, this.u, this.v, this.iw, this.ih);
        }
        int col = this.getColor();
        if (!this.isEnabled()) {
            col = this.getDisabledColor();
        }
        if (this.text == null) {
            graphics.m_280056_(this.mc.f_91062_, "", x + dx + this.bounds.x, y + dy + this.bounds.y, col, false);
        } else {
            graphics.m_280056_(this.mc.f_91062_, this.mc.f_91062_.m_92834_(this.text, this.bounds.width), x + dx + this.bounds.x, y + dy + this.bounds.y, col, false);
        }
    }

    private int calculateVerticalOffset() {
        if (this.verticalAlignment != VerticalAlignment.ALIGN_TOP) {
            Objects.requireNonNull(this.mc.f_91062_);
            int h = 9;
            if (this.verticalAlignment == VerticalAlignment.ALIGN_BOTTOM) {
                return this.bounds.height - h;
            }
            return (this.bounds.height - h) / 2;
        }
        return 0;
    }

    private int calculateHorizontalOffset() {
        if (this.horizontalAlignment != HorizontalAlignment.ALIGN_LEFT) {
            int w = this.mc.f_91062_.m_92895_(this.text);
            if (this.horizontalAlignment == HorizontalAlignment.ALIGN_RIGHT) {
                return this.bounds.width - w;
            }
            return (this.bounds.width - w) / 2;
        }
        return 0;
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        this.text = command.getOptionalPar(1, "");
        this.color = GuiParser.get(command, "color", null);
        this.disabledColor = GuiParser.get(command, "disabledcolor", null);
        this.horizontalAlignment = HorizontalAlignment.getByName(GuiParser.get(command, "horizalign", DEFAULT_HORIZONTAL_ALIGN.name()));
        this.verticalAlignment = VerticalAlignment.getByName(GuiParser.get(command, "vertalign", DEFAULT_VERTICAL_ALIGN.name()));
        this.dynamic = GuiParser.get(command, "dynamic", false);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        command.parameter(this.text);
        GuiParser.put(command, "color", this.color, null);
        GuiParser.put(command, "disabledcolor", this.disabledColor, null);
        GuiParser.put(command, "horizalign", this.horizontalAlignment.name(), DEFAULT_HORIZONTAL_ALIGN.name());
        GuiParser.put(command, "vertalign", this.verticalAlignment.name(), DEFAULT_VERTICAL_ALIGN.name());
        GuiParser.put(command, "dynamic", this.dynamic, false);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_LABEL);
    }

    @Override
    public <T> void setGenericValue(T value) {
        if (value == null) {
            this.text("");
        } else {
            this.text(value.toString());
        }
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        return this.getText();
    }
}

