/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.processor.RandomSettings;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class ApplyRandomStructureProcessor
extends StructureProcessor {
    private static final Codec<SimpleWeightedRandomList<Holder<StructureProcessorList>>> WEIGHTED_LIST_CODEC = SimpleWeightedRandomList.m_185860_((Codec)StructureProcessorType.f_74468_);
    private static final Codec<HolderSet<StructureProcessorList>> SET_CODEC = RegistryCodecs.m_206279_((ResourceKey)Registries.f_257011_, (Codec)StructureProcessorType.f_74467_);
    public static final Codec<ApplyRandomStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LithostitchedCodecs.withAlternative(WEIGHTED_LIST_CODEC, SET_CODEC, ApplyRandomStructureProcessor::convertToWeightedList).fieldOf("processor_lists").forGetter(ApplyRandomStructureProcessor::processorLists), (App)RandomSettings.CODEC.fieldOf("mode").forGetter(ApplyRandomStructureProcessor::randomSettings)).apply((Applicative)instance, ApplyRandomStructureProcessor::new));
    public static final StructureProcessorType<ApplyRandomStructureProcessor> TYPE = () -> CODEC;
    private final SimpleWeightedRandomList<Holder<StructureProcessorList>> processorLists;
    private final RandomSettings randomSettings;

    private static SimpleWeightedRandomList<Holder<StructureProcessorList>> convertToWeightedList(HolderSet<StructureProcessorList> set) {
        SimpleWeightedRandomList.Builder weightedList = SimpleWeightedRandomList.m_146263_();
        for (Holder processor : set) {
            weightedList.m_146271_((Object)processor, 1);
        }
        return weightedList.m_146270_();
    }

    public ApplyRandomStructureProcessor(SimpleWeightedRandomList<Holder<StructureProcessorList>> processorLists, RandomSettings randomSettings) {
        this.processorLists = processorLists;
        this.randomSettings = randomSettings;
    }

    public ApplyRandomStructureProcessor(HolderSet<StructureProcessorList> set, RandomSettings mode) {
        this(ApplyRandomStructureProcessor.convertToWeightedList(set), mode);
    }

    public SimpleWeightedRandomList<Holder<StructureProcessorList>> processorLists() {
        return this.processorLists;
    }

    public RandomSettings randomSettings() {
        return this.randomSettings;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        WorldGenLevel level;
        RandomSource random;
        Optional processorList;
        if (levelReader instanceof WorldGenLevel && (processorList = this.processorLists.m_216820_(random = this.randomSettings.create(level = (WorldGenLevel)levelReader, pos, absolute))).isPresent()) {
            StructureProcessor processor;
            StructureTemplate.StructureBlockInfo processedBlock = absolute;
            Iterator iterator = ((StructureProcessorList)((Holder)processorList.get()).m_203334_()).m_74425_().iterator();
            while (iterator.hasNext() && (processedBlock = (processor = (StructureProcessor)iterator.next()).m_7382_(levelReader, pos, pivot, relative, processedBlock, settings)) != null) {
            }
            return processedBlock;
        }
        return absolute;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return TYPE;
    }
}

