/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brewingstation;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.brewingstation.BrewingstationBlock;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.registry.BlockStateRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BrewTimerBlock
extends BrewingstationBlock {
    public static final BooleanProperty TIME;
    public static final BooleanProperty ACTIVATED;
    public static final BooleanProperty PRESSED;
    private static final int PRESS_DURATION = 60;
    private static int pressedTime;
    private static boolean canBePressed;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;
    private long lastSoundTime = 0L;

    public BrewTimerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).m_61124_((Property)TIME, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PRESSED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (Boolean.TRUE.equals(blockState.m_61143_((Property)TIME))) {
            level.m_46597_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)TIME, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TIME, ACTIVATED, PRESSED});
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (Boolean.TRUE.equals(blockState.m_61143_((Property)TIME))) {
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 1.2;
            double z = (double)blockPos.m_123343_() + 0.5;
            DustParticleOptions redDust = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastSoundTime >= 900L) {
                level.m_7785_(x, y, z, (SoundEvent)DoApiSoundEventRegistry.BREWSTATION_TIMER_LOOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                this.lastSoundTime = currentTime;
            }
            for (int i = 0; i < 4; ++i) {
                double offsetX = randomSource.m_188500_() * 0.6 - 0.3;
                double offsetZ = randomSource.m_188500_() * 0.6 - 0.3;
                level.m_7106_((ParticleOptions)redDust, x + offsetX, y, z + offsetZ, 1.0, 0.0, 0.0);
            }
            if (!Boolean.TRUE.equals(blockState.m_61143_((Property)ACTIVATED))) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    static {
        canBePressed = false;
        TIME = BlockStateRegistry.TIME;
        PRESSED = BooleanProperty.m_61465_((String)"pressed");
        ACTIVATED = BooleanProperty.m_61465_((String)"activated");
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.9375, (double)0.5, (double)0.875, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.6875, (double)0.9375, (double)0.8125, (double)0.8125, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.5, (double)0.9375, (double)0.8125, (double)0.625, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)1.0, (double)0.9375));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.875));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)0.875));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.9375, (double)0.0, (double)0.875, (double)1.0, (double)0.875));
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
    }
}

