/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.tank;

import cats.implicits$;
import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.MCImplicits$;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.TransferFluid;
import com.kotori316.fluidtank.fluids.TransferFluid$;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.TankPos;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import java.io.Serializable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import scala.Function1;

public class BlockTank
extends Block
implements EntityBlock {
    private final Tier tier;
    private final ItemBlockTank itemBlock;

    public BlockTank(Tier tier) {
        this.tier = tier;
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60988_().m_278166_(PushReaction.BLOCK).m_280606_());
        this.m_49959_((BlockState)this.m_49965_().m_61090_().m_61124_(TankPos.TANK_POS_PROPERTY, (Comparable)TankPos.SINGLE));
        this.itemBlock = this.createTankItem();
    }

    public Tier tier() {
        return this.tier;
    }

    public final ItemBlockTank itemBlock() {
        return this.itemBlock;
    }

    public ItemBlockTank createTankItem() {
        return new ItemBlockTank(this);
    }

    public final Item m_5456_() {
        return this.itemBlock();
    }

    public String toString() {
        return "Block{" + this.tier().getBlockName() + "}";
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileTank(this.tier(), pos, state);
    }

    public final boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tank = (TileTank)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (player.m_21205_().m_41619_()) {
                if (!level.f_46443_) {
                    player.m_5661_(tank.getConnection().getTextComponent(), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(stack.m_41720_() instanceof ItemBlockTank)) {
                if (PlatformFluidAccess.getInstance().isFluidContainer(stack)) {
                    if (!level.f_46443_) {
                        return (InteractionResult)TransferFluid$.MODULE$.transferFluid(tank.getConnection(), stack, player, hand).map((Function1 & Serializable)r -> {
                            TransferFluid$.MODULE$.setItem(player, hand, (TransferFluid.Result)r, pos);
                            return InteractionResult.CONSUME;
                        }).getOrElse(BlockTank::use$$anonfun$2);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {}", (Object)implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), (Object)tile);
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tank = (TileTank)blockEntity;
            if (!level.f_46443_) {
                tank.onBlockPlacedBy();
                return;
            }
            return;
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {}", (Object)implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), (Object)tile);
    }

    public final boolean m_7278_(BlockState state) {
        return true;
    }

    public final int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank = (TileTank)blockEntity;
            return tileTank.getComparatorLevel();
        }
        BlockEntity tile = blockEntity;
        FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {}", (Object)implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), (Object)tile);
        return 0;
    }

    public final void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TileTank) {
                TileTank tank = (TileTank)blockEntity;
                tank.onDestroy();
            } else {
                BlockEntity tile = blockEntity;
                FluidTankCommon.LOGGER.error(FluidTankCommon.MARKER_TANK, "There is not TileTank at {}, but {}", (Object)implicits$.MODULE$.toShow((Object)pos, MCImplicits$.MODULE$.showPos()).show(), (Object)tile);
            }
            super.m_6810_(state, level, pos, newState, moved);
            return;
        }
    }

    public void saveTankNBT(BlockEntity tileEntity, ItemStack stack) {
        BlockEntity blockEntity = tileEntity;
        if (blockEntity instanceof TileTank) {
            TileTank tank = (TileTank)blockEntity;
            if (!tank.getTank().isEmpty()) {
                stack.m_41700_("BlockEntityTag", (Tag)tank.m_187482_());
            }
            if (tank.m_8077_()) {
                stack.m_41714_(tank.m_7770_());
                return;
            }
            return;
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        this.saveTankNBT(level.m_7702_(pos), stack);
        return stack;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FluidTankCommon.TANK_SHAPE;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TankPos.TANK_POS_PROPERTY});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return super.m_142354_(level, state, blockEntityType);
        }
        if (PlatformTankAccess.isTankType(blockEntityType)) {
            return (_$1, _$2, _$3, tile) -> ((TileTank)tile).onTickLoading();
        }
        return null;
    }

    private static final InteractionResult use$$anonfun$2() {
        return InteractionResult.PASS;
    }
}

