/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.reservoir;

import cats.implicits$;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.TankUtil$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.fluids.package$;
import com.kotori316.fluidtank.tank.Tier;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import scala.;
import scala.$less$colon$less$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public class ItemReservoir
extends Item {
    private final Tier tier;

    public ItemReservoir(Tier tier) {
        this.tier = tier;
        super(new Item.Properties().m_41487_(1));
    }

    public Tier tier() {
        return this.tier;
    }

    public String toString() {
        return "ItemReservoir(" + this.tier().name().toLowerCase(Locale.ROOT) + ")";
    }

    public UseAnim m_6164_(ItemStack stack) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion v = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return UseAnim.DRINK;
            }
        }
        return super.m_6164_(stack);
    }

    public int m_8105_(ItemStack stack) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion v = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return 32;
            }
        }
        return super.m_8105_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        GenericAmount<FluidLike> content = this.getTank(stack).content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion v = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)usedHand);
            }
        }
        if (fluidLike instanceof VanillaFluid) {
            BlockHitResult hitResult = Item.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            HitResult.Type type = hitResult.m_6662_();
            HitResult.Type type2 = HitResult.Type.BLOCK;
            if (type == null ? type2 != null : !type.equals(type2)) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            return this.fillOrDrainFluidInLevel(hitResult, stack, level, player, content, usedHand);
        }
        return super.m_7203_(level, player, usedHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        Tank<FluidLike> tank = this.getTank(stack);
        GenericAmount<FluidLike> content = tank.content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion && content.hasOneBottle()) {
            List effects = PotionUtils.m_43566_((CompoundTag)((CompoundTag)content.nbt().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            effects.forEach(e -> {
                if (e.m_19544_().m_8093_()) {
                    e.m_19544_().m_19461_((Entity)livingEntity, (Entity)livingEntity, livingEntity, e.m_19564_(), 1.0);
                    return;
                }
                livingEntity.m_7292_(e);
            });
            Object object = implicits$.MODULE$.catsSyntaxGroup((Object)new GenericUnit(content.amount()), GenericUnit$.MODULE$.groupGenericUnit()).$bar$minus$bar((Object)new GenericUnit(GenericUnit$.MODULE$.ONE_BOTTLE()));
            Tank<FluidLike> newTank = tank.copy(content.setAmount(object == null ? null : ((GenericUnit)object).value()), tank.copy$default$2());
            this.saveTank(stack, newTank);
            return stack;
        }
        return stack;
    }

    public Rarity m_41460_(ItemStack stack) {
        if (stack.m_41737_("tank") != null) {
            return Rarity.UNCOMMON;
        }
        return super.m_41460_(stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltip, isAdvanced);
        Tank<FluidLike> tank = this.getTank(stack);
        if (tank.isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"fluidtank.waila.capacity", (Object[])new Object[]{GenericUnit$.MODULE$.asForgeFromBigInt(this.tier().getCapacity())}));
            return;
        }
        GenericAmount<FluidLike> fluid = tank.content();
        BigInt capacity = tank.capacity();
        tooltip.add((Component)Component.m_237110_((String)"fluidtank.waila.short", (Object[])new Object[]{PlatformFluidAccess.getInstance().getDisplayName(fluid), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount())), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(capacity))}));
    }

    public Tank<FluidLike> getTank(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("tank");
        if (tag == null) {
            return Tank$.MODULE$.apply(FluidAmountUtil$.MODULE$.EMPTY(), GenericUnit$.MODULE$.apply(this.tier().getCapacity()));
        }
        return TankUtil$.MODULE$.load(tag, package$.MODULE$.fluidAccess());
    }

    public void saveTank(ItemStack stack, Tank<FluidLike> tank) {
        if (tank.isEmpty()) {
            stack.m_41749_("tank");
            return;
        }
        stack.m_41700_("tank", (Tag)TankUtil$.MODULE$.save(tank, package$.MODULE$.fluidAccess()));
    }

    private InteractionResultHolder<ItemStack> fillOrDrainFluidInLevel(BlockHitResult hitResult, ItemStack stack, Level level, Player player, GenericAmount<FluidLike> content, InteractionHand hand) {
        BlockPos hitPos = hitResult.m_82425_();
        Direction hitFace = hitResult.m_82434_();
        if (level.m_7966_(player, hitPos) && player.m_36204_(hitPos.m_121945_(hitFace), hitFace, stack)) {
            BlockState blockState = level.m_8055_(hitPos);
            GenericAmount<FluidLike> simulateFluid = FluidAmountUtil$.MODULE$.from(level.m_6425_(hitPos).m_76152_(), GenericUnit$.MODULE$.ONE_BUCKET());
            Block block = blockState.m_60734_();
            if (block instanceof BucketPickup) {
                Block pickUp = (Block)((BucketPickup)block);
                if (content.isEmpty() || content.contentEqual(simulateFluid)) {
                    PlatformFluidAccess.TransferStack simulation = PlatformFluidAccess.getInstance().fillItem(simulateFluid, stack, player, hand, false);
                    if (simulation.moved().nonEmpty()) {
                        ItemStack picked = ((BucketPickup)pickUp).m_142598_((LevelAccessor)level, hitPos, blockState);
                        GenericAmount<FluidLike> actualFluid = PlatformFluidAccess.getInstance().getFluidContained(picked);
                        PlatformFluidAccess.TransferStack result = PlatformFluidAccess.getInstance().fillItem(actualFluid, stack, player, hand, true);
                        return InteractionResultHolder.m_19092_((Object)result.toReplace(), (boolean)level.f_46443_);
                    }
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }
}

