/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

final class Wrapper {
    private static final Vector4f vector4f = new Vector4f();
    private final VertexConsumer buffer;

    Wrapper(VertexConsumer buffer) {
        this.buffer = buffer;
    }

    private static Vector4f getPosVector(float x, float y, float z, PoseStack matrix) {
        Matrix4f matrix4f = matrix.m_85850_().m_252922_();
        vector4f.set(x, y, z, 1.0f);
        vector4f.mul((Matrix4fc)matrix4f);
        return vector4f;
    }

    Wrapper pos(double x, double y, double z, PoseStack matrix) {
        Vector4f vector4f = Wrapper.getPosVector((float)x, (float)y, (float)z, matrix);
        this.buffer.m_5483_((double)vector4f.x(), (double)vector4f.y(), (double)vector4f.z());
        return this;
    }

    Wrapper color(int red, int green, int blue, int alpha) {
        this.buffer.m_6122_(red, green, blue, alpha);
        return this;
    }

    Wrapper tex(float u, float v) {
        this.buffer.m_7421_(u, v);
        return this;
    }

    Wrapper lightmap(int sky, int block) {
        this.buffer.m_7122_(10, 10).m_7120_(block, sky);
        return this;
    }

    Wrapper lightMap(int light, int overlay) {
        this.buffer.m_86008_(overlay).m_85969_(light);
        return this;
    }

    void endVertex() {
        this.buffer.m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public VertexConsumer buffer() {
        return this.buffer;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Wrapper that = (Wrapper)obj;
        return Objects.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return Objects.hash(this.buffer);
    }

    public String toString() {
        return "Wrapper[buffer=" + this.buffer + "]";
    }
}

