/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.render.Box;
import com.kotori316.fluidtank.render.Box$;
import com.kotori316.fluidtank.render.RenderReservoirItem$;
import com.kotori316.fluidtank.render.ReservoirModel;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;

public abstract class RenderReservoirItem
extends BlockEntityWithoutLevelRenderer {
    private ReservoirModel model;

    public RenderReservoirItem() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Tank<FluidLike> tank;
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        poseStack.m_252880_(0.0f, 0.0f, 0.5f);
        ItemReservoir reservoir = (ItemReservoir)stack.m_41720_();
        VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_((ResourceLocation)RenderReservoirItem$.com$kotori316$fluidtank$render$RenderReservoirItem$$$textureNameMap.apply((Object)reservoir.tier())), (boolean)true, (boolean)stack.m_41790_());
        RenderSystem.enableCull();
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (stack.m_41782_() && (tank = reservoir.getTank(stack)).hasContent()) {
            double ratio = Mth.m_14008_((double)(GenericUnit$.MODULE$.asForgeDouble$extension(tank.content().amount()) / GenericUnit$.MODULE$.asForgeDouble$extension(tank.capacity())), (double)0.1, (double)1.0);
            Tuple2.mcDD.sp sp2 = tank.content().isGaseous() ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(1.0 - ratio)), (Object)BoxesRunTime.boxToDouble((double)1.0)) : new Tuple2.mcDD.sp(0.0, ratio);
            double minY = sp2._1$mcD$sp();
            double maxY = sp2._2$mcD$sp();
            Box box = Box$.MODULE$.apply(0.5, minY, 0.03125, 0.5, maxY, 0.03125, 0.74375, maxY - minY, 0.061875, false, false);
            TextureAtlasSprite texture = this.getFluidTexture(tank);
            int color = this.getFluidColor(tank);
            int alpha = (color >> 24 & 0xFF) > 0 ? color >> 24 & 0xFF : 255;
            box.render(buffer.m_6299_(RenderType.m_110466_()), poseStack, texture, alpha, color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, Box$.MODULE$.lightValue());
        }
        poseStack.m_85849_();
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.model = new ReservoirModel(Minecraft.m_91087_().m_167973_().m_171103_(ReservoirModel.LOCATION));
    }

    public abstract TextureAtlasSprite getFluidTexture(Tank<FluidLike> var1);

    public abstract int getFluidColor(Tank<FluidLike> var1);
}

