/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.render.Box$;
import com.kotori316.fluidtank.render.Box$LightValue$;
import com.kotori316.fluidtank.render.Wrapper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.Serializable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Box {
    private final double startX;
    private final double startY;
    private final double startZ;
    private final double endX;
    private final double endY;
    private final double endZ;
    private final double sizeX;
    private final double sizeY;
    private final double sizeZ;
    private final boolean firstSide;
    private final boolean endSide;
    private final double dx;
    private final double dy;
    private final double dz;
    private final double lengthSq;
    private final double length;
    private final double offX;
    private final double offY;
    private final double offZ;
    private final double maxSize;

    public static Box apply(AABB aABB, double d, double d2, double d3, boolean bl, boolean bl2) {
        return Box$.MODULE$.apply(aABB, d, d2, d3, bl, bl2);
    }

    public static Box apply(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl, boolean bl2) {
        return Box$.MODULE$.apply(d, d2, d3, d4, d5, d6, d7, d8, d9, bl, bl2);
    }

    public static LightValue lightValue() {
        return Box$.MODULE$.lightValue();
    }

    public Box(double startX, double startY, double startZ, double endX, double endY, double endZ, double sizeX, double sizeY, double sizeZ, boolean firstSide, boolean endSide) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.firstSide = firstSide;
        this.endSide = endSide;
        this.dx = endX - startX;
        this.dy = endY - startY;
        this.dz = endZ - startZ;
        this.lengthSq = this.dx() * this.dx() + this.dy() * this.dy() + this.dz() * this.dz();
        this.length = Math.sqrt(this.lengthSq());
        this.offX = sizeX / (double)2;
        this.offY = sizeY / (double)2;
        this.offZ = sizeZ / (double)2;
        this.maxSize = Math.max(Math.max(sizeX, sizeY), sizeZ);
    }

    public double startX() {
        return this.startX;
    }

    public double startY() {
        return this.startY;
    }

    public double startZ() {
        return this.startZ;
    }

    public double endX() {
        return this.endX;
    }

    public double endY() {
        return this.endY;
    }

    public double endZ() {
        return this.endZ;
    }

    public double sizeX() {
        return this.sizeX;
    }

    public double sizeY() {
        return this.sizeY;
    }

    public double sizeZ() {
        return this.sizeZ;
    }

    public boolean firstSide() {
        return this.firstSide;
    }

    public boolean endSide() {
        return this.endSide;
    }

    public double dx() {
        return this.dx;
    }

    public double dy() {
        return this.dy;
    }

    public double dz() {
        return this.dz;
    }

    public double lengthSq() {
        return this.lengthSq;
    }

    public double length() {
        return this.length;
    }

    public double offX() {
        return this.offX;
    }

    public double offY() {
        return this.offY;
    }

    public double offZ() {
        return this.offZ;
    }

    public double maxSize() {
        return this.maxSize;
    }

    public void render(VertexConsumer buffer, PoseStack matrix, TextureAtlasSprite sprite, int alpha, int red, int green, int blue, LightValue lightValue) {
        double n1X = this.dx();
        double n1Y = Box$.MODULE$.normalY(this.dx(), this.dy(), this.dz());
        double n1Z = this.dz();
        double n1Size = Math.sqrt(n1X * n1X + n1Y * n1Y + n1Z * n1Z);
        double n2X = this.dy() * n1Z - this.dz() * n1Y;
        double n2Z = this.dx() * n1Y - this.dy() * n1X;
        double n2Size = Math.sqrt(n2X * n2X + n2Z * n2Z);
        this.renderInternal(buffer, matrix, sprite, n1X / n1Size / (double)2, n1Y / n1Size / (double)2, n1Z / n1Size / (double)2, n2X / n2Size / (double)2, n2Z / n2Size / (double)2, lightValue, alpha, red, green, blue);
    }

    public int render$default$4() {
        return 255;
    }

    public int render$default$5() {
        return 255;
    }

    public int render$default$6() {
        return 255;
    }

    public int render$default$7() {
        return 255;
    }

    public final void renderInternal(VertexConsumer r, PoseStack matrix, TextureAtlasSprite sprite, double n1X, double n1Y, double n1Z, double n2X, double n2Z, LightValue lv, int alpha, int red, int green, int blue) {
        Wrapper buffer = new Wrapper(r);
        double eX = this.dx() / this.length() * this.sizeX();
        double eY = this.dy() / this.length() * this.sizeY();
        double eZ = this.dz() / this.length() * this.sizeZ();
        double e1X = this.startX() + n1X * this.sizeX() + n2X * this.sizeX();
        double e1Y = this.startY() + n1Y * this.sizeY();
        double e1Z = this.startZ() + n1Z * this.sizeZ() + n2Z * this.sizeZ();
        double e2X = this.startX() - n1X * this.sizeX() + n2X * this.sizeX();
        double e2Y = this.startY() - n1Y * this.sizeY();
        double e2Z = this.startZ() - n1Z * this.sizeZ() + n2Z * this.sizeZ();
        double e3X = this.startX() - n1X * this.sizeX() - n2X * this.sizeX();
        double e3Y = e2Y;
        double e3Z = this.startZ() - n1Z * this.sizeZ() - n2Z * this.sizeZ();
        double e4X = this.startX() + n1X * this.sizeX() - n2X * this.sizeX();
        double e4Y = e1Y;
        double e4Z = this.startZ() + n1Z * this.sizeZ() - n2Z * this.sizeZ();
        if (this.firstSide()) {
            buffer.pos(e1X, e1Y, e1Z, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X, e2Y, e2Z, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X, e3Y, e3Z, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X, e4Y, e4Z, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
        }
        double l = Math.sqrt(this.dx() / this.sizeX() * this.dx() / this.sizeX() + this.dy() / this.sizeY() * this.dy() / this.sizeY() + this.dz() / this.sizeZ() * this.dz() / this.sizeZ());
        int lengthFloor = Mth.m_14107_((double)l);
        for (int i1 = 0; i1 <= lengthFloor; ++i1) {
            double i2 = i1 == lengthFloor ? l : (double)i1 + 1.0;
            buffer.pos(e1X + eX * i2, e1Y + eY * i2, e1Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e1X + eX * (double)i1, e1Y + eY * (double)i1, e1Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X + eX * (double)i1, e2Y + eY * (double)i1, e2Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X + eX * i2, e2Y + eY * i2, e2Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X + eX * i2, e2Y + eY * i2, e2Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X + eX * (double)i1, e2Y + eY * (double)i1, e2Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X + eX * (double)i1, e3Y + eY * (double)i1, e3Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X + eX * i2, e3Y + eY * i2, e3Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X + eX * i2, e3Y + eY * i2, e3Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X + eX * (double)i1, e3Y + eY * (double)i1, e3Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X + eX * (double)i1, e4Y + eY * (double)i1, e4Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X + eX * i2, e4Y + eY * i2, e4Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X + eX * i2, e4Y + eY * i2, e4Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X + eX * (double)i1, e4Y + eY * (double)i1, e4Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e1X + eX * (double)i1, e1Y + eY * (double)i1, e1Z + eZ * (double)i1, matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e1X + eX * i2, e1Y + eY * i2, e1Z + eZ * i2, matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
        }
        if (this.endSide()) {
            buffer.pos(e1X + this.dx(), e1Y + this.dy(), e1Z + this.dz(), matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e2X + this.dx(), e2Y + this.dy(), e2Z + this.dz(), matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118411_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e3X + this.dx(), e3Y + this.dy(), e3Z + this.dz(), matrix).color(red, green, blue, alpha).tex(sprite.m_118410_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            buffer.pos(e4X + this.dx(), e4Y + this.dy(), e4Z + this.dz(), matrix).color(red, green, blue, alpha).tex(sprite.m_118409_(), sprite.m_118412_()).lightmap(lv.l1(), lv.l2()).endVertex();
            return;
        }
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof Box) {
            Box o = (Box)object;
            return this.startX() == o.startX() && this.startY() == o.startY() && this.startZ() == o.startZ() && this.endX() == o.endX() && this.endY() == o.endY() && this.endZ() == o.endZ() && this.sizeX() == o.sizeX() && this.sizeY() == o.sizeY() && this.sizeZ() == o.sizeZ() && this.firstSide() == o.firstSide() && this.endSide() == o.endSide();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.startX() + this.startY() + this.startZ() + this.endX() + this.endY() + this.endZ() + this.sizeX() + this.sizeY() + this.sizeZ() + (double)(this.firstSide() ? 1 : 0) + (double)(this.endSide() ? 1 : 0));
    }

    public static class LightValue
    implements Product,
    Serializable {
        private final int brightness;
        private final int sky;
        private final int block;

        public static LightValue apply(int n) {
            return Box$LightValue$.MODULE$.apply(n);
        }

        public static LightValue fromProduct(Product product) {
            return Box$LightValue$.MODULE$.fromProduct(product);
        }

        public static LightValue unapply(LightValue lightValue) {
            return Box$LightValue$.MODULE$.unapply(lightValue);
        }

        public LightValue(int brightness) {
            this.brightness = brightness;
            this.sky = brightness >> 16 & 0xFFFF;
            this.block = brightness >> 0 & 0xFFFF;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.brightness());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LightValue)) return false;
            LightValue lightValue = (LightValue)object;
            if (this.brightness() != lightValue.brightness()) return false;
            if (!lightValue.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LightValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LightValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "brightness";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int brightness() {
            return this.brightness;
        }

        public final int sky() {
            return this.sky;
        }

        public final int block() {
            return this.block;
        }

        public int l1() {
            return this.sky();
        }

        public int l2() {
            return this.block();
        }

        public LightValue overrideBlock(int light) {
            if (light * 16 > this.block()) {
                return this.copy(this.sky() << 16 | light * 16);
            }
            return this;
        }

        public LightValue copy(int brightness) {
            return new LightValue(brightness);
        }

        public int copy$default$1() {
            return this.brightness();
        }

        public int _1() {
            return this.brightness();
        }
    }
}

