/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TankUtil;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TierRecipe
implements CraftingRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierRecipe.class);
    private final ResourceLocation id;
    private final Tier tier;
    private final Ingredient tankItem;
    private final Ingredient subItem;
    private final ItemStack result;
    private static final int recipeWidth = 3;
    private static final int recipeHeight = 3;
    public static final String KEY_TIER = "tier";
    public static final String KEY_SUB_ITEM = "sub_item";

    protected TierRecipe(ResourceLocation id, Tier tier, Ingredient tankItem, Ingredient subItem) {
        this.id = id;
        this.tier = tier;
        this.tankItem = tankItem;
        this.subItem = subItem;
        this.result = new ItemStack((ItemLike)PlatformTankAccess.getInstance().getTankBlockMap().get((Object)tier).get());
        LOGGER.debug("{} instance({}) created for Tier {}({}).", new Object[]{this.getClass().getSimpleName(), id, tier, this.result});
    }

    public boolean matches(CraftingContainer inv, @Nullable Level worldIn) {
        return this.checkInv(inv);
    }

    private boolean checkInv(CraftingContainer inv) {
        for (int i = 0; i <= inv.m_39347_() - 3; ++i) {
            for (int j = 0; j <= inv.m_39346_() - 3; ++j) {
                if (!this.checkMatch(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkMatch(CraftingContainer craftingInventory, int w, int h) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - w;
                int l = j - h;
                Ingredient ingredient = k >= 0 && l >= 0 && k < 3 && l < 3 ? (Ingredient)ingredients.get(3 - k - 1 + l * 3) : Ingredient.f_43901_;
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        List<ItemStack> tankStacks = IntStream.range(0, craftingInventory.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)craftingInventory).m_8020_(arg_0)).filter((Predicate<ItemStack>)this.tankItem).toList();
        return tankStacks.size() == 4 && tankStacks.stream().map(BlockItem::m_186336_).filter(Objects::nonNull).map(nbt -> TankUtil.load(nbt.m_128469_(TileTank.KEY_TANK()), FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).map(FluidLikeKey::from).distinct().count() <= 1L;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        if (!this.checkInv(inv)) {
            LOGGER.error("Requested to return crafting result for invalid inventory. {}", IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)inv).m_8020_(arg_0)).collect(Collectors.toList()));
            return ItemStack.f_41583_;
        }
        ItemStack result = this.m_8043_(access);
        GenericAmount<FluidLike> fluidAmount = IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)inv).m_8020_(arg_0)).filter(s -> s.m_41720_() instanceof ItemBlockTank).map(BlockItem::m_186336_).filter(Objects::nonNull).map(nbt -> TankUtil.load(nbt.m_128469_(TileTank.KEY_TANK()), FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).reduce(GenericAmount::add).orElse(FluidAmountUtil.EMPTY());
        if (fluidAmount.nonEmpty()) {
            CompoundTag compound = new CompoundTag();
            Tank<FluidLike> tank = new Tank<FluidLike>(fluidAmount, GenericUnit.apply(this.tier.getCapacity()));
            CompoundTag tankTag = TankUtil.save(tank, FluidAmountUtil.access());
            compound.m_128365_(TileTank.KEY_TANK(), (Tag)tankTag);
            compound.m_128359_(TileTank.KEY_TIER(), this.tier.name());
            PlatformItemAccess.setTileTag(result, compound);
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.tankItem);
        ingredients.add((Object)this.subItem);
        ingredients.add((Object)this.tankItem);
        ingredients.add((Object)this.subItem);
        ingredients.add((Object)Ingredient.f_43901_);
        ingredients.add((Object)this.subItem);
        ingredients.add((Object)this.tankItem);
        ingredients.add((Object)this.subItem);
        ingredients.add((Object)this.tankItem);
        return ingredients;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)inv).m_8020_(arg_0)).map(stack -> {
            if (stack.m_41720_() instanceof ItemBlockTank) {
                return ItemStack.f_41583_;
            }
            return PlatformItemAccess.getInstance().getCraftingRemainingItem((ItemStack)stack);
        }).collect(Collectors.toCollection(NonNullList::m_122779_));
    }

    public Tier getTier() {
        return this.tier;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static abstract class SerializerBase
    implements RecipeSerializer<TierRecipe> {
        public static final ResourceLocation LOCATION = new ResourceLocation("fluidtank", "crafting_grade_up");

        protected abstract TierRecipe createInstance(ResourceLocation var1, Tier var2, Ingredient var3, Ingredient var4);

        public TierRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Tier tier = Tier.valueOf(GsonHelper.m_13906_((JsonObject)serializedRecipe, (String)TierRecipe.KEY_TIER).toUpperCase(Locale.ROOT));
            Ingredient tankItem = SerializerBase.getIngredientTankForTier(tier);
            Ingredient subItem = Ingredient.m_43917_((JsonElement)serializedRecipe.get(TierRecipe.KEY_SUB_ITEM));
            if (subItem == Ingredient.f_43901_) {
                LOGGER.warn("Empty ingredient was loaded for {}, data: {}", (Object)recipeId, (Object)serializedRecipe);
            }
            LOGGER.debug("Serializer loaded {} from json for tier {}, sub {}.", new Object[]{recipeId, tier, PlatformItemAccess.convertIngredientToString(subItem)});
            return this.createInstance(recipeId, tier, tankItem, subItem);
        }

        public void toJson(JsonObject object, TierRecipe recipe) {
            object.addProperty(TierRecipe.KEY_TIER, recipe.tier.name());
            object.add(TierRecipe.KEY_SUB_ITEM, recipe.subItem.m_43942_());
        }

        public TierRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String tierName = buffer.m_130277_();
            Tier tier = Tier.valueOf(tierName);
            Ingredient tankItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient subItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            if (subItem == Ingredient.f_43901_) {
                LOGGER.warn("Empty ingredient was loaded for {}", (Object)recipeId);
            }
            LOGGER.debug("Serializer loaded {} from packet for tier {}, sub {}.", new Object[]{recipeId, tier, PlatformItemAccess.convertIngredientToString(subItem)});
            return this.createInstance(recipeId, tier, tankItem, subItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, TierRecipe recipe) {
            buffer.m_130070_(recipe.tier.name());
            recipe.tankItem.m_43923_(buffer);
            recipe.subItem.m_43923_(buffer);
            LOGGER.debug("Serialized {} to packet for tier {}.", (Object)recipe.id, (Object)recipe.tier);
        }

        @VisibleForTesting
        public static Ingredient getIngredientTankForTier(Tier tier) {
            Stream<Tier> targetTiers = Stream.of(Tier.values()).filter(t -> t.getRank() == tier.getRank() - 1);
            Stream<ItemStack> itemStream = targetTiers.map(PlatformTankAccess.getInstance().getTankBlockMap()::get).map(Supplier::get).map(ItemStack::new);
            return Ingredient.m_43921_(itemStream);
        }
    }
}

