/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.potions;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLike$;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler$;
import java.io.Serializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.mutable.Seq;
import scala.runtime.function.JProcedure1;

public interface PotionFluidHandler {
    public static PotionFluidHandler apply(ItemStack itemStack) {
        return PotionFluidHandler$.MODULE$.apply(itemStack);
    }

    public static Seq<PartialFunction<ItemStack, PotionFluidHandler>> handlerProvider() {
        return PotionFluidHandler$.MODULE$.handlerProvider();
    }

    public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> var1, VanillaPotion var2);

    public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> var1, VanillaPotion var2);

    public GenericAmount<FluidLike> getContent();

    public static boolean isValidHandler$(PotionFluidHandler $this) {
        return $this.isValidHandler();
    }

    default public boolean isValidHandler() {
        return true;
    }

    public static class NotContainer
    implements PotionFluidHandler {
        private final ItemStack stack;

        public NotContainer(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            return FluidAmountUtil$.MODULE$.EMPTY();
        }

        @Override
        public boolean isValidHandler() {
            return false;
        }
    }

    public static class VanillaEmptyBottle
    implements PotionFluidHandler {
        private final ItemStack stack;

        public VanillaEmptyBottle(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            if (toFill.hasOneBottle()) {
                ItemStack filledItem = new ItemStack((ItemLike)vanillaPotion.potionType().getItem());
                toFill.nbt().foreach((Function1)(JProcedure1 & Serializable)c -> filledItem.m_41751_(c));
                GenericAmount<FluidLike> moved = toFill.setAmount(GenericUnit$.MODULE$.ONE_BOTTLE());
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferStack(moved, filledItem);
            }
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            return FluidAmountUtil$.MODULE$.EMPTY();
        }
    }

    public static class VanillaPotionBottle
    implements PotionFluidHandler {
        private final ItemStack stack;

        public VanillaPotionBottle(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public PlatformFluidAccess.TransferStack fill(GenericAmount<FluidLike> toFill, VanillaPotion vanillaPotion) {
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
        }

        @Override
        public PlatformFluidAccess.TransferStack drain(GenericAmount<FluidLike> toDrain, VanillaPotion vanillaPotion) {
            if (toDrain.isEmpty() || !toDrain.hasOneBottle()) {
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
            }
            GenericAmount<FluidLike> content = this.getContent();
            if (!content.hasOneBottle() || !toDrain.contentEqual(content)) {
                return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferFailed(this.stack);
            }
            ItemStack drainedItem = Items.f_42590_.m_7968_();
            GenericAmount<FluidLike> moved = toDrain.setAmount(GenericUnit$.MODULE$.ONE_BOTTLE());
            return PotionFluidHandler$.MODULE$.com$kotori316$fluidtank$potions$PotionFluidHandler$$$transferStack(moved, drainedItem);
        }

        @Override
        public GenericAmount<FluidLike> getContent() {
            PotionType potionType = PotionType.fromItemUnsafe(this.stack.m_41720_());
            return FluidAmountUtil$.MODULE$.from(FluidLike$.MODULE$.of(potionType), GenericUnit$.MODULE$.ONE_BOTTLE(), (Option<CompoundTag>)Option$.MODULE$.apply((Object)this.stack.m_41783_()));
        }
    }
}

