/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.message;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TankUtil;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.message.IMessage;
import com.kotori316.fluidtank.tank.TileTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class FluidTankContentMessage
implements IMessage<FluidTankContentMessage> {
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final Tank<FluidLike> tank;

    public FluidTankContentMessage(BlockPos pos, ResourceKey<Level> dim, Tank<FluidLike> tank) {
        this.pos = pos;
        this.dim = dim;
        this.tank = tank;
    }

    public FluidTankContentMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.dim = buf.m_236801_(Registries.f_256858_);
        this.tank = TankUtil.load(buf.m_130260_(), FluidAmountUtil.access());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos).m_236858_(this.dim);
        CompoundTag tag = TankUtil.save(this.tank, FluidAmountUtil.access());
        buf.m_130079_(tag);
    }

    public void onReceive(@Nullable Level level) {
        if (level == null || !level.m_46472_().equals(this.dim)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof TileTank) {
            TileTank tileTank = (TileTank)blockEntity;
            tileTank.setTank(this.tank);
        }
    }
}

