/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.integration.tooltip;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.TileVoidTank;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.ChainingOps$;
import scala.util.package;

public final class TooltipContent$
implements Serializable {
    private static final ResourceLocation JADE_TOOLTIP_UID;
    private static final ResourceLocation TOP_TOOLTIP_UID;
    private static final ResourceLocation JADE_CONFIG_SHORT;
    private static final ResourceLocation JADE_CONFIG_COMPACT;
    public static final TooltipContent$ MODULE$;

    private TooltipContent$() {
    }

    static {
        MODULE$ = new TooltipContent$();
        JADE_TOOLTIP_UID = new ResourceLocation("fluidtank", "jade_plugin");
        TOP_TOOLTIP_UID = new ResourceLocation("fluidtank", "top_plugin");
        JADE_CONFIG_SHORT = new ResourceLocation("fluidtank", "short_info");
        JADE_CONFIG_COMPACT = new ResourceLocation("fluidtank", "compact_number");
        String KEY_TIER = "tier";
        String KEY_FLUID = "fluid";
        String KEY_CAPACITY = "capacity";
        String KEY_COMPARATOR = "comparator";
        String KEY_CREATIVE = "hasCreative";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TooltipContent$.class);
    }

    public final ResourceLocation JADE_TOOLTIP_UID() {
        return JADE_TOOLTIP_UID;
    }

    public final ResourceLocation TOP_TOOLTIP_UID() {
        return TOP_TOOLTIP_UID;
    }

    public final ResourceLocation JADE_CONFIG_SHORT() {
        return JADE_CONFIG_SHORT;
    }

    public final ResourceLocation JADE_CONFIG_COMPACT() {
        return JADE_CONFIG_COMPACT;
    }

    public final void addServerData(CompoundTag compoundTag, BlockEntity entity) {
        BlockEntity blockEntity = entity;
        if (blockEntity instanceof TileVoidTank) {
            TileVoidTank voidTank = (TileVoidTank)blockEntity;
            compoundTag.m_128359_("tier", voidTank.tier().toString());
            return;
        }
        if (blockEntity instanceof TileTank) {
            TileTank tank = (TileTank)blockEntity;
            compoundTag.m_128359_("tier", tank.tier().toString());
            compoundTag.m_128365_("fluid", (Tag)((GenericAmount)tank.getConnection().getContent().getOrElse(this::addServerData$$anonfun$1)).getTag());
            compoundTag.m_128379_("hasCreative", tank.getConnection().hasCreative());
            if (!tank.getConnection().hasCreative()) {
                compoundTag.m_128356_("capacity", GenericUnit$.MODULE$.asDisplay$extension(tank.getConnection().capacity()));
                compoundTag.m_128405_("comparator", tank.getConnection().getComparatorLevel());
                return;
            }
            return;
        }
    }

    public final Seq<Component> getTooltipText(CompoundTag tankData, TileTank tank, boolean isShort, boolean isCompact, Locale locale) {
        return this.getTooltipText(tank.tier(), FluidAmountUtil$.MODULE$.fromTag(tankData.m_128469_("fluid")), tankData.m_128454_("capacity"), tankData.m_128451_("comparator"), tankData.m_128471_("hasCreative"), isShort, isCompact, locale);
    }

    public final Seq<Component> getTooltipText(Tier tier, GenericAmount<FluidLike> fluid, long capacity, int comparator, boolean hasCreative, boolean isShort, boolean isCompact, Locale locale) {
        MutableComponent fluidName;
        Function1 & Serializable intersect;
        if (isCompact) {
            NumberFormat numberFormat = (NumberFormat)package.chaining$.MODULE$.scalaUtilChainingOps((Object)NumberFormat.getCompactNumberInstance(locale, NumberFormat.Style.SHORT));
            NumberFormat numberFormat2 = (NumberFormat)package.chaining$.MODULE$.scalaUtilChainingOps(ChainingOps$.MODULE$.tap$extension((Object)numberFormat, (Function1)(JProcedure1 & Serializable)_$1 -> _$1.setMinimumFractionDigits(1)));
            NumberFormat formatter = (NumberFormat)ChainingOps$.MODULE$.tap$extension((Object)numberFormat2, (Function1)(JProcedure1 & Serializable)_$2 -> _$2.setRoundingMode(RoundingMode.DOWN));
            intersect = (Function1 & Serializable)n -> this.$anonfun$3(formatter, BoxesRunTime.unboxToLong((Object)n));
        } else {
            intersect = (Function1 & Serializable)n -> this.$anonfun$4(BoxesRunTime.unboxToLong((Object)n));
        }
        Function1 & Serializable numberFormat = intersect;
        Object object = fluidName = fluid.nonEmpty() ? PlatformFluidAccess.getInstance().getDisplayName(fluid) : Component.m_237115_((String)"chat.fluidtank.empty");
        if (isShort) {
            Tier tier2 = tier;
            Tier tier3 = Tier.VOID;
            if (!(tier2 != null ? !((Object)((Object)tier2)).equals((Object)tier3) : tier3 != null)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            if (hasCreative) {
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{fluidName}));
            }
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MutableComponent[]{Component.m_237110_((String)"fluidtank.waila.short", (Object[])new Object[]{fluidName, numberFormat.apply((Object)BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount()))), numberFormat.apply((Object)BoxesRunTime.boxToLong((long)capacity))})}));
        }
        Tier tier4 = tier;
        Tier tier5 = Tier.VOID;
        if (!(tier4 != null ? !((Object)((Object)tier4)).equals((Object)tier5) : tier5 != null)) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        if (hasCreative) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{fluidName}));
        }
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Component[]{fluidName, Component.m_237110_((String)"fluidtank.waila.amount", (Object[])new Object[]{numberFormat.apply((Object)BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount())))}), Component.m_237110_((String)"fluidtank.waila.capacity", (Object[])new Object[]{numberFormat.apply((Object)BoxesRunTime.boxToLong((long)capacity))}), Component.m_237110_((String)"fluidtank.waila.comparator", (Object[])new Object[]{BoxesRunTime.boxToInteger((int)comparator)})}));
    }

    private final GenericAmount addServerData$$anonfun$1() {
        return FluidAmountUtil$.MODULE$.EMPTY();
    }

    private final /* synthetic */ String $anonfun$3(NumberFormat formatter$1, long n) {
        return formatter$1.format(n);
    }

    private final /* synthetic */ String $anonfun$4(long n) {
        return BoxesRunTime.boxToLong((long)n).toString();
    }
}

