/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.tank;

import com.kotori316.fluidtank.fluids.FluidConnection;
import com.kotori316.fluidtank.forge.tank.ConnectionHandler;
import com.kotori316.fluidtank.tank.TileVoidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TileVoidTankForge
extends TileVoidTank {
    private LazyOptional<IFluidHandler> fluidHandler = this.createHandler();

    public TileVoidTankForge(BlockPos p, BlockState s) {
        super(p, s);
    }

    @Override
    public void setConnection(FluidConnection c) {
        super.setConnection(c);
        this.fluidHandler.invalidate();
        this.fluidHandler = this.createHandler();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    private LazyOptional<IFluidHandler> createHandler() {
        return LazyOptional.of(() -> new ConnectionHandler(this.getConnection()));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fluidHandler = this.createHandler();
    }
}

