/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.tank;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidConnection;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.forge.message.FluidTankContentMessageForge;
import com.kotori316.fluidtank.forge.message.PacketHandler;
import com.kotori316.fluidtank.forge.tank.ConnectionHandler;
import com.kotori316.fluidtank.tank.TileCreativeTank;
import com.kotori316.fluidtank.tank.VisualTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TileCreativeTankForge
extends TileCreativeTank {
    private LazyOptional<IFluidHandler> fluidHandler = this.createHandler();
    public VisualTank visualTank;

    public TileCreativeTankForge(BlockPos p, BlockState s) {
        super(p, s);
    }

    @Override
    public void setConnection(FluidConnection c) {
        super.setConnection(c);
        this.fluidHandler.invalidate();
        this.fluidHandler = this.createHandler();
    }

    @Override
    public void setTank(Tank<FluidLike> tank) {
        super.setTank(tank);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PacketHandler.sendToClient(new FluidTankContentMessageForge(this), this.f_58857_);
        } else {
            if (this.visualTank == null) {
                this.visualTank = new VisualTank();
            }
            this.visualTank.updateContent(tank.capacity(), tank.amount(), tank.content().isGaseous());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    private LazyOptional<IFluidHandler> createHandler() {
        return LazyOptional.of(() -> new ConnectionHandler(this.getConnection()));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fluidHandler = this.createHandler();
    }
}

