/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.tank;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.TankUtil$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.package$;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter$;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter$FluidAmount2FluidStack$;
import com.kotori316.fluidtank.forge.fluid.TankFluidHandler;
import com.kotori316.fluidtank.tank.Tier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.VisibleForTesting;

public class TankFluidItemHandler
implements TankFluidHandler,
ICapabilityProvider {
    private final Tier tier;
    private final ItemStack stack;
    private final LazyOptional<IFluidHandlerItem> handler;

    public TankFluidItemHandler(Tier tier, ItemStack stack) {
        this.tier = tier;
        this.stack = stack;
        this.handler = LazyOptional.of(() -> this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction arg) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.handler);
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    @Override
    public Tank<FluidLike> getTank() {
        CompoundTag tag = BlockItem.m_186336_((ItemStack)this.getContainer());
        if (tag == null || !tag.m_128441_("tank")) {
            return Tank$.MODULE$.apply(FluidAmountUtil$.MODULE$.EMPTY(), GenericUnit$.MODULE$.apply(this.tier.getCapacity()));
        }
        return TankUtil$.MODULE$.load(tag.m_128469_("tank"), package$.MODULE$.fluidAccess());
    }

    @Override
    public void saveTank(Tank<FluidLike> tank) {
        if (tank.isEmpty()) {
            this.getContainer().m_41749_("BlockEntityTag");
            return;
        }
        CompoundTag tankTag = TankUtil$.MODULE$.save(tank, package$.MODULE$.fluidAccess());
        CompoundTag tag = this.getContainer().m_41698_("BlockEntityTag");
        tag.m_128365_("tank", (Tag)tankTag);
        tag.m_128359_("tier", this.tier.name());
    }

    @VisibleForTesting
    public void fill(GenericAmount<FluidLike> fill, boolean execute) {
        this.fill(ForgeConverter$FluidAmount2FluidStack$.MODULE$.toStack$extension(ForgeConverter$.MODULE$.FluidAmount2FluidStack(fill)), execute ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
    }
}

