/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.reservoir;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.forge.fluid.TankFluidHandler;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ReservoirFluidHandler
implements TankFluidHandler,
ICapabilityProvider {
    private final ItemReservoir reservoir;
    private final ItemStack stack;
    private final LazyOptional<IFluidHandlerItem> handler;

    public ReservoirFluidHandler(ItemReservoir reservoir, ItemStack stack) {
        this.reservoir = reservoir;
        this.stack = stack;
        this.handler = LazyOptional.of(() -> this);
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction arg) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.handler);
    }

    @Override
    public Tank<FluidLike> getTank() {
        return this.reservoir.getTank(this.stack);
    }

    @Override
    public void saveTank(Tank<FluidLike> newTank) {
        this.reservoir.saveTank(this.stack, newTank);
    }
}

