/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.render;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter;
import com.kotori316.fluidtank.render.RenderReservoirItem;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import scala.jdk.javaapi.OptionConverters;

public final class RenderReservoirItemForge
extends RenderReservoirItem {
    public static final RenderReservoirItemForge INSTANCE = new RenderReservoirItemForge();

    @Override
    public TextureAtlasSprite getFluidTexture(Tank<FluidLike> tank) {
        Fluid fluid = FluidLike.asFluid(tank.content().content(), (Fluid)Fluids.f_76193_);
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation location = attributes.getStillTexture(fluid.m_76145_(), (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20097_());
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);
    }

    @Override
    public int getFluidColor(Tank<FluidLike> tank) {
        GenericAmount<FluidLike> content = tank.content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaFluid) {
            VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)vanillaFluid.fluid());
            int normal = attributes.getTintColor();
            if (attributes == IClientFluidTypeExtensions.DEFAULT) {
                return normal;
            }
            int stackColor = attributes.getTintColor(ForgeConverter.toStack(content));
            if (normal == stackColor) {
                return attributes.getTintColor(vanillaFluid.fluid().m_76145_(), (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20097_());
            }
            return stackColor;
        }
        if (content.content() instanceof VanillaPotion) {
            return PotionUtils.m_43564_((Collection)OptionConverters.toJava(content.nbt()).map(PotionUtils::m_43566_).orElse(List.of()));
        }
        throw new IllegalArgumentException("Unknown fluid type " + content);
    }
}

