/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.kotori316.fluidtank.FluidTankCommon;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public final class IgnoreUnknownTagIngredient
extends AbstractIngredient {
    public static final IIngredientSerializer<IgnoreUnknownTagIngredient> SERIALIZER = new Serializer();
    private final List<? extends Ingredient.Value> values;

    public IgnoreUnknownTagIngredient(List<? extends Ingredient.Value> values) {
        super(values.stream());
        this.values = values;
    }

    public static IgnoreUnknownTagIngredient of(ItemLike item) {
        return new IgnoreUnknownTagIngredient(List.of(new Ingredient.ItemValue(new ItemStack(item))));
    }

    public static IgnoreUnknownTagIngredient of(TagKey<Item> tag) {
        return new IgnoreUnknownTagIngredient(List.of(new TagValue(tag)));
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID(SERIALIZER)).toString());
        if (this.values.size() == 1) {
            JsonObject value = this.values.get(0).m_6544_();
            value.entrySet().forEach(e -> json.add((String)e.getKey(), (JsonElement)e.getValue()));
            return json;
        }
        JsonArray values = this.values.stream().map(Ingredient.Value::m_6544_).reduce(new JsonArray(), (a, object) -> {
            a.add((JsonElement)object);
            return a;
        }, (a1, a2) -> {
            a1.addAll(a2);
            return a1;
        });
        json.add("values", (JsonElement)values);
        return json;
    }

    private static final class TagValue
    implements Ingredient.Value {
        private final TagKey<Item> tag;

        private TagValue(TagKey<Item> tag) {
            this.tag = tag;
        }

        public Collection<ItemStack> m_6223_() {
            ITagManager manager = ForgeRegistries.ITEMS.tags();
            if (manager == null) {
                FluidTankCommon.LOGGER.warn("[IgnoreUnknownTagIngredient] Can't get items from tag {}", this.tag);
                return List.of();
            }
            return manager.getTag(this.tag).stream().map(ItemStack::new).toList();
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.f_203868_().toString());
            return json;
        }
    }

    private static class Serializer
    implements IIngredientSerializer<IgnoreUnknownTagIngredient> {
        private Serializer() {
        }

        public IgnoreUnknownTagIngredient parse(FriendlyByteBuf buffer) {
            return new IgnoreUnknownTagIngredient(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()).toList());
        }

        public IgnoreUnknownTagIngredient parse(JsonObject json) {
            List<Ingredient.Value> valueList;
            if (json.has("item") || json.has("tag")) {
                valueList = List.of(Serializer.getValue(json));
            } else if (json.has("values")) {
                valueList = StreamSupport.stream(json.getAsJsonArray("values").spliterator(), false).map(JsonElement::getAsJsonObject).map(Serializer::getValue).toList();
            } else {
                throw new JsonParseException("An IgnoreUnknownTagIngredient entry needs either a tag, an item or an array");
            }
            return new IgnoreUnknownTagIngredient(valueList);
        }

        private static Ingredient.Value getValue(JsonObject json) {
            if (json.has("item")) {
                Item item = ShapedRecipe.m_151278_((JsonObject)json);
                return new Ingredient.ItemValue(new ItemStack((ItemLike)item));
            }
            if (json.has("tag")) {
                ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourcelocation);
                return new TagValue((TagKey<Item>)tagkey);
            }
            throw new JsonParseException("An IgnoreUnknownTagIngredient entry needs either a tag or an item");
        }

        public void write(FriendlyByteBuf arg, IgnoreUnknownTagIngredient arg2) {
            VanillaIngredientSerializer.INSTANCE.write(arg, (Ingredient)arg2);
        }
    }
}

