/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.message;

import com.kotori316.fluidtank.forge.message.FluidTankContentMessageForge;
import com.kotori316.fluidtank.message.IMessage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketHandler {
    private static final String PROTOCOL = "1";
    private static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("fluidtank", "main")).networkProtocolVersion(() -> "1").clientAcceptedVersions(Predicate.isEqual("1")).serverAcceptedVersions(Predicate.isEqual("1")).simpleChannel();

    public static void init() {
        AtomicInteger count = new AtomicInteger(1);
        CHANNEL.registerMessage(count.getAndIncrement(), FluidTankContentMessageForge.class, IMessage::write, FluidTankContentMessageForge::new, PacketHandler.setHandled(FluidTankContentMessageForge::onReceive));
    }

    static <MSG> BiConsumer<MSG, Supplier<NetworkEvent.Context>> setHandled(BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        return (msg, supplier) -> {
            messageConsumer.accept((Object)msg, (Supplier<NetworkEvent.Context>)supplier);
            ((NetworkEvent.Context)supplier.get()).setPacketHandled(true);
        };
    }

    public static void sendToClient(IMessage<?> message, Level level) {
        CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), message);
    }
}

