/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.integration.jade;

import com.kotori316.fluidtank.integration.tooltip.TooltipContent;
import com.kotori316.fluidtank.tank.TileTank;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class FluidTankJadeProvider
implements IServerDataProvider<BlockAccessor>,
IBlockComponentProvider {
    FluidTankJadeProvider() {
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof TileTank) {
            TileTank tileTank = (TileTank)blockEntity;
            Seq<Component> content = TooltipContent.getTooltipText(accessor.getServerData(), tileTank, config.get(TooltipContent.JADE_CONFIG_SHORT()), config.get(TooltipContent.JADE_CONFIG_COMPACT()), Minecraft.m_91087_().getLocale());
            tooltip.addAll(CollectionConverters.asJava(content));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        TooltipContent.addServerData(compoundTag, accessor.getBlockEntity());
    }

    public ResourceLocation getUid() {
        return TooltipContent.JADE_TOOLTIP_UID();
    }

    public int getDefaultPriority() {
        return 0;
    }
}

