/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.fluid;

import cats.Invariant$;
import cats.Monad;
import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import com.kotori316.fluidtank.contents.DefaultTransferEnv$;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TransferEnv;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter$;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter$FluidAmount2FluidStack$;
import com.kotori316.fluidtank.forge.fluid.ForgeConverter$FluidStack2FluidAmount$;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import scala.Int$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;

public interface TankFluidHandler
extends IFluidHandlerItem {
    public Tank<FluidLike> getTank();

    public void saveTank(Tank<FluidLike> var1);

    public static int getTanks$(TankFluidHandler $this) {
        return $this.getTanks();
    }

    default public int getTanks() {
        return 1;
    }

    public static int getTankCapacity$(TankFluidHandler $this, int i) {
        return $this.getTankCapacity(i);
    }

    default public int getTankCapacity(int i) {
        return GenericUnit$.MODULE$.asForge$extension(this.getTank().capacity());
    }

    public static FluidStack getFluidInTank$(TankFluidHandler $this, int i) {
        return $this.getFluidInTank(i);
    }

    default public FluidStack getFluidInTank(int i) {
        return ForgeConverter$FluidAmount2FluidStack$.MODULE$.toStack$extension(ForgeConverter$.MODULE$.FluidAmount2FluidStack(this.getTank().content()));
    }

    public static boolean isFluidValid$(TankFluidHandler $this, int i, FluidStack fluidStack) {
        return $this.isFluidValid(i, fluidStack);
    }

    default public boolean isFluidValid(int i, FluidStack fluidStack) {
        return true;
    }

    public static int fill$(TankFluidHandler $this, FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return $this.fill(fluidStack, fluidAction);
    }

    default public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<FluidLike>, GenericAmount<FluidLike>, Tank<FluidLike>> op = this.getTank().fillOp();
        Tuple3 tuple3 = (Tuple3)op.run((Object)DefaultTransferEnv$.MODULE$, ForgeConverter$FluidStack2FluidAmount$.MODULE$.toAmount$extension(ForgeConverter$.MODULE$.FluidStack2FluidAmount(fluidStack)), (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        GenericAmount rest = (GenericAmount)tuple3._2();
        Tank tank = (Tank)tuple3._3();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)rest, (Object)tank);
        GenericAmount rest2 = (GenericAmount)tuple2._1();
        Tank tank2 = (Tank)tuple2._2();
        if (fluidAction.execute()) {
            this.saveTank(tank2);
        }
        return fluidStack.getAmount() - GenericUnit$.MODULE$.asForge$extension(rest2.amount());
    }

    public static FluidStack drain$(TankFluidHandler $this, FluidStack drain, IFluidHandler.FluidAction fluidAction) {
        return $this.drain(drain, fluidAction);
    }

    default public FluidStack drain(FluidStack drain, IFluidHandler.FluidAction fluidAction) {
        Tank<FluidLike> tank = this.getTank();
        if (tank.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(tank, ForgeConverter$FluidStack2FluidAmount$.MODULE$.toAmount$extension(ForgeConverter$.MODULE$.FluidStack2FluidAmount(drain)), fluidAction);
    }

    public static FluidStack drain$(TankFluidHandler $this, int amount, IFluidHandler.FluidAction fluidAction) {
        return $this.drain(amount, fluidAction);
    }

    default public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
        Tank<FluidLike> tank = this.getTank();
        if (tank.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(tank, tank.content().setAmount(GenericUnit$.MODULE$.fromForge(Int$.MODULE$.int2long(amount))), fluidAction);
    }

    private FluidStack drainInternal(Tank<FluidLike> tank, GenericAmount<FluidLike> drainAmount, IFluidHandler.FluidAction fluidAction) {
        Tuple3 tuple3 = (Tuple3)tank.drainOp().run((Object)DefaultTransferEnv$.MODULE$, drainAmount, (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        GenericAmount rest = (GenericAmount)tuple3._2();
        Tank newTank = (Tank)tuple3._3();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)rest, (Object)newTank);
        GenericAmount rest2 = (GenericAmount)tuple2._1();
        Tank newTank2 = (Tank)tuple2._2();
        if (fluidAction.execute()) {
            this.saveTank(newTank2);
        }
        return ForgeConverter$FluidAmount2FluidStack$.MODULE$.toStack$extension(ForgeConverter$.MODULE$.FluidAmount2FluidStack(drainAmount.$minus(rest2)));
    }
}

