/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge.cat;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.forge.FluidTank;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Option;
import scala.math.BigInt;

public class EntityChestAsTank
extends BlockEntity {
    @NotNull
    private LazyOptional<FluidHandlerProxy> proxy = LazyOptional.empty();

    public EntityChestAsTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)FluidTank.TILE_CAT.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ForgeCapabilities.FLUID_HANDLER == cap) {
            if (!this.proxy.isPresent()) {
                this.proxy = this.createProxy();
            }
            return this.proxy.cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<FluidHandlerProxy> createProxy() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        BlockPos pos = this.m_58899_().m_121945_(facing);
        Optional<LazyOptional> handler = Optional.ofNullable(this.m_58904_()).map(l -> l.m_7702_(pos)).flatMap(b -> {
            LazyOptional o = b.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_());
            o.addListener(h -> this.markInvalid());
            return o.filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast);
        }).or(() -> Optional.ofNullable(HopperBlockEntity.m_59390_((Level)this.m_58904_(), (BlockPos)pos)).map(InvWrapper::new));
        return handler.map(i -> LazyOptional.of(() -> new FluidHandlerProxy((IItemHandlerModifiable)i))).orElse(LazyOptional.empty());
    }

    private void markInvalid() {
        this.proxy.invalidate();
        this.proxy = LazyOptional.empty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.markInvalid();
    }

    public Optional<List<GenericAmount<FluidLike>>> getFluids() {
        return this.proxy.map(FluidHandlerProxy::fluids).map(m -> m.entrySet().stream().map(e -> ((FluidLikeKey)e.getKey()).toAmount((BigInt)e.getValue())).toList());
    }

    static class FluidHandlerProxy
    implements IFluidHandler {
        private final IItemHandlerModifiable inventory;

        FluidHandlerProxy(IItemHandlerModifiable inventory) {
            this.inventory = inventory;
        }

        LazyOptional<IFluidHandlerItem> getHandler(int slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            return FluidUtil.getFluidHandler((ItemStack)stack);
        }

        public int getTanks() {
            return this.inventory.getSlots();
        }

        @NotNull
        public FluidStack getFluidInTank(int i) {
            return this.getHandler(i).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        }

        public int getTankCapacity(int i) {
            return this.getHandler(i).map(h -> h.getTankCapacity(0)).orElse(0);
        }

        public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
            return this.getHandler(i).map(h -> h.isFluidValid(0, fluidStack)).orElse(false);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction fluidAction) {
            if (resource == null || resource.isEmpty()) {
                return 0;
            }
            FluidStack rest = resource.copy();
            for (int i = 0; i < this.getTanks(); ++i) {
                LazyOptional handlerO;
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_() || stack.m_41613_() > 1 || !(handlerO = FluidUtil.getFluidHandler((ItemStack)stack)).isPresent()) continue;
                IFluidHandlerItem handler = (IFluidHandlerItem)handlerO.orElseThrow(AssertionError::new);
                int filled = handler.fill(rest, fluidAction);
                rest.shrink(filled);
                if (fluidAction.execute()) {
                    this.inventory.setStackInSlot(i, handler.getContainer());
                }
                if (!rest.isEmpty()) continue;
                return resource.getAmount();
            }
            return resource.getAmount() - rest.getAmount();
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction fluidAction) {
            if (resource == null || resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack rest = resource.copy();
            for (int i = 0; i < this.getTanks(); ++i) {
                LazyOptional handlerO;
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_() || stack.m_41613_() > 1 || !(handlerO = FluidUtil.getFluidHandler((ItemStack)stack)).isPresent()) continue;
                IFluidHandlerItem handler = (IFluidHandlerItem)handlerO.orElseThrow(AssertionError::new);
                FluidStack drained = handler.drain(rest, fluidAction);
                rest.shrink(drained.getAmount());
                if (fluidAction.execute()) {
                    this.inventory.setStackInSlot(i, handler.getContainer());
                }
                if (!rest.isEmpty()) continue;
                return resource;
            }
            rest.setAmount(resource.getAmount() - rest.getAmount());
            return rest;
        }

        @NotNull
        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            if (amount <= 0) {
                return FluidStack.EMPTY;
            }
            Optional<FluidStack> toDrain = IntStream.range(0, this.getTanks()).mapToObj(this::getFluidInTank).filter(Predicate.not(FluidStack::isEmpty)).findFirst().map(FluidStack::copy);
            return toDrain.map(f -> {
                f.setAmount(amount);
                return this.drain((FluidStack)f, fluidAction);
            }).orElse(FluidStack.EMPTY);
        }

        Map<FluidLikeKey, BigInt> fluids() {
            return IntStream.range(0, this.getTanks()).mapToObj(this::getFluidInTank).filter(Predicate.not(FluidStack::isEmpty)).collect(Collectors.groupingBy(f -> FluidLikeKey.apply(FluidLike.of(f.getFluid()), (Option<CompoundTag>)Option.apply((Object)f.getTag())), Collectors.reducing(BigInt.apply((int)0), f -> GenericUnit.asBigIntFromForge(f.getAmount()), BigInt::$plus)));
        }
    }
}

