/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge;

import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.forge.FluidTank;
import com.kotori316.fluidtank.forge.render.RenderReservoirItemForge;
import com.kotori316.fluidtank.forge.render.RenderTank;
import com.kotori316.fluidtank.render.ReservoirModel;
import java.util.Optional;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public abstract class SideProxy {
    public abstract Optional<Level> getLevel(NetworkEvent.Context var1);

    public static SideProxy get() {
        return switch (FMLEnvironment.dist) {
            default -> throw new IncompatibleClassChangeError();
            case Dist.CLIENT -> ClientProxy.client();
            case Dist.DEDICATED_SERVER -> ServerProxy.server();
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientProxy
    extends SideProxy {
        private ClientProxy() {
        }

        private static SideProxy client() {
            return new ClientProxy();
        }

        @SubscribeEvent
        public void registerTESR(FMLClientSetupEvent event) {
            FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Client Initialize {}", (Object)"fluidtank");
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)FluidTank.TILE_TANK_TYPE.get()), RenderTank::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)FluidTank.TILE_CREATIVE_TANK_TYPE.get()), RenderTank::new);
            FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Client Initialize finished {}", (Object)"fluidtank");
        }

        @Override
        public Optional<Level> getLevel(NetworkEvent.Context context) {
            Optional<Level> serverWorld = Optional.ofNullable(context.getSender()).map(Entity::m_20193_);
            return serverWorld.or(() -> (Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide()));
        }

        @SubscribeEvent
        public void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ReservoirModel.LOCATION, ReservoirModel::createDefinition);
        }

        @SubscribeEvent
        public void registerReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)RenderReservoirItemForge.INSTANCE);
        }
    }

    private static class ServerProxy
    extends SideProxy {
        private ServerProxy() {
        }

        private static SideProxy server() {
            return new ServerProxy();
        }

        @Override
        public Optional<Level> getLevel(NetworkEvent.Context context) {
            return Optional.ofNullable(context.getSender()).map(Entity::m_20193_);
        }
    }
}

