/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.forge;

import com.kotori316.fluidtank.DebugLogging;
import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.PlatformAccess;
import com.kotori316.fluidtank.cat.BlockChestAsTank;
import com.kotori316.fluidtank.cat.ItemChestAsTank;
import com.kotori316.fluidtank.config.PlatformConfigAccess;
import com.kotori316.fluidtank.forge.ForgePlatformAccess;
import com.kotori316.fluidtank.forge.SideProxy;
import com.kotori316.fluidtank.forge.cat.EntityChestAsTank;
import com.kotori316.fluidtank.forge.config.ForgePlatformConfigAccess;
import com.kotori316.fluidtank.forge.integration.ae2.AE2FluidTankIntegration;
import com.kotori316.fluidtank.forge.integration.top.FluidTankTopPlugin;
import com.kotori316.fluidtank.forge.message.PacketHandler;
import com.kotori316.fluidtank.forge.recipe.IgnoreUnknownTagIngredient;
import com.kotori316.fluidtank.forge.recipe.TierRecipeForge;
import com.kotori316.fluidtank.forge.reservoir.ItemReservoirForge;
import com.kotori316.fluidtank.forge.tank.BlockCreativeTankForge;
import com.kotori316.fluidtank.forge.tank.BlockTankForge;
import com.kotori316.fluidtank.forge.tank.BlockVoidTankForge;
import com.kotori316.fluidtank.forge.tank.TileCreativeTankForge;
import com.kotori316.fluidtank.forge.tank.TileTankForge;
import com.kotori316.fluidtank.forge.tank.TileVoidTankForge;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.TankLootFunction;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileCreativeTank;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.TileVoidTank;
import com.mojang.datafixers.DSL;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="fluidtank")
public final class FluidTank {
    public static final SideProxy proxy = SideProxy.get();
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"fluidtank");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fluidtank");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"fluidtank");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"fluidtank");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"fluidtank");
    public static final Map<Tier, RegistryObject<BlockTankForge>> TANK_MAP = Stream.of(Tier.values()).filter(Tier::isNormalTankTier).collect(Collectors.toMap(Function.identity(), t -> BLOCK_REGISTER.register(t.getBlockName(), () -> new BlockTankForge((Tier)((Object)t)))));
    public static final RegistryObject<BlockCreativeTankForge> BLOCK_CREATIVE_TANK = BLOCK_REGISTER.register(Tier.CREATIVE.getBlockName(), BlockCreativeTankForge::new);
    public static final RegistryObject<BlockVoidTankForge> BLOCK_VOID_TANK = BLOCK_REGISTER.register(Tier.VOID.getBlockName(), BlockVoidTankForge::new);
    public static final Map<Tier, RegistryObject<ItemBlockTank>> TANK_ITEM_MAP = Stream.concat(TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, BLOCK_VOID_TANK))).collect(Collectors.toMap(Map.Entry::getKey, e -> ITEM_REGISTER.register(((Tier)((Object)((Object)e.getKey()))).getBlockName(), () -> ((BlockTank)((Object)((Object)((Object)((RegistryObject)e.getValue()).get())))).itemBlock())));
    public static final RegistryObject<BlockEntityType<TileTankForge>> TILE_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> BlockEntityType.Builder.m_155273_(TileTankForge::new, (Block[])((Block[])TANK_MAP.values().stream().map(RegistryObject::get).toArray(BlockTank[]::new))).m_58966_(DSL.emptyPartType()));
    public static final RegistryObject<BlockEntityType<TileCreativeTankForge>> TILE_CREATIVE_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileCreativeTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> BlockEntityType.Builder.m_155273_(TileCreativeTankForge::new, (Block[])new Block[]{(Block)BLOCK_CREATIVE_TANK.get()}).m_58966_(DSL.emptyPartType()));
    public static final RegistryObject<BlockEntityType<TileVoidTankForge>> TILE_VOID_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileVoidTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> BlockEntityType.Builder.m_155273_(TileVoidTankForge::new, (Block[])new Block[]{(Block)BLOCK_VOID_TANK.get()}).m_58966_(DSL.emptyPartType()));
    public static final LootItemFunctionType TANK_LOOT_FUNCTION = new LootItemFunctionType((Serializer)new TankLootFunction.TankLootSerializer());
    public static final RegistryObject<RecipeSerializer<?>> TIER_RECIPE = RECIPE_REGISTER.register(TierRecipeForge.Serializer.LOCATION.m_135815_(), () -> TierRecipeForge.SERIALIZER);
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TAB_REGISTER.register("tab", () -> {
        CreativeModeTab.Builder b = CreativeModeTab.builder();
        FluidTank.createTab(b);
        return b.m_257652_();
    });
    public static final RegistryObject<BlockChestAsTank> BLOCK_CAT = BLOCK_REGISTER.register(BlockChestAsTank.NAME(), BlockChestAsTank::new);
    public static final RegistryObject<BlockItem> ITEM_CAT = ITEM_REGISTER.register(BlockChestAsTank.NAME(), () -> new ItemChestAsTank((Block)BLOCK_CAT.get()));
    public static final RegistryObject<BlockEntityType<EntityChestAsTank>> TILE_CAT = BLOCK_ENTITY_REGISTER.register(BlockChestAsTank.NAME(), () -> BlockEntityType.Builder.m_155273_(EntityChestAsTank::new, (Block[])new Block[]{(Block)BLOCK_CAT.get()}).m_58966_(DSL.emptyPartType()));
    public static final Map<Tier, RegistryObject<ItemReservoirForge>> RESERVOIR_MAP = Stream.of(Tier.WOOD, Tier.STONE, Tier.IRON).collect(Collectors.toMap(Function.identity(), t -> ITEM_REGISTER.register("reservoir_" + t.name().toLowerCase(Locale.ROOT), () -> new ItemReservoirForge((Tier)((Object)t)))));

    public FluidTank() {
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize {}", (Object)"fluidtank");
        ForgeMod.enableMilkFluid();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCK_REGISTER.register(modBus);
        ITEM_REGISTER.register(modBus);
        CREATIVE_TAB_REGISTER.register(modBus);
        BLOCK_ENTITY_REGISTER.register(modBus);
        RECIPE_REGISTER.register(modBus);
        PlatformAccess.setInstance(new ForgePlatformAccess());
        FluidTank.setupConfig(modBus);
        modBus.register((Object)this);
        modBus.register((Object)proxy);
        PacketHandler.init();
        AE2FluidTankIntegration.onAPIAvailable();
        FluidTankTopPlugin.sendIMC();
        MinecraftForge.EVENT_BUS.addListener(FluidTank::onServerStart);
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize finished {}", (Object)"fluidtank");
    }

    private static void setupConfig(IEventBus modBus) {
        ForgePlatformConfigAccess config = new ForgePlatformConfigAccess();
        modBus.register((Object)config);
        ForgeConfigSpec.Builder builder = config.setupConfig();
        PlatformConfigAccess.setInstance(config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void callRegister(RegisterEvent event) {
        LazyHolder.init(event);
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((ResourceLocation)new ResourceLocation("fluidtank", "ignore_unknown_tag_ingredient"), IgnoreUnknownTagIngredient.SERIALIZER);
        }
    }

    private static void createTab(CreativeModeTab.Builder builder) {
        builder.m_257737_(() -> (ItemStack)TANK_MAP.get((Object)Tier.WOOD).map(ItemStack::new).orElseThrow());
        builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.fluidtank"));
        builder.m_257501_((parameters, output) -> {
            TANK_ITEM_MAP.values().stream().map(RegistryObject::get).sorted(Comparator.comparing(i -> i.blockTank().tier())).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
            output.m_246326_((ItemLike)ITEM_CAT.get());
            RESERVOIR_MAP.values().stream().map(RegistryObject::get).sorted(Comparator.comparing(ItemReservoir::tier)).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0));
        });
    }

    static void onServerStart(ServerStartedEvent event) {
        DebugLogging.initialLog(event.getServer());
    }

    public static final class LazyHolder {
        private static void init(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)Registries.f_257015_)) {
                Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)new ResourceLocation("fluidtank", "content_tank"), (Object)TANK_LOOT_FUNCTION);
            }
        }
    }
}

