/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccessHolder;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformFluidAccess {
    @NotNull
    public static PlatformFluidAccess getInstance() {
        return PlatformFluidAccessHolder.platformFluidAccess;
    }

    public static void setInstance(@NotNull PlatformFluidAccess access) {
        PlatformFluidAccessHolder.platformFluidAccess = access;
    }

    public boolean isGaseous(Fluid var1);

    @NotNull
    public Fluid getBucketContent(BucketItem var1);

    @NotNull
    default public GenericAmount<FluidLike> getFluidContained(ItemStack stack) {
        PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
        if (potionHandler.isValidHandler()) {
            return potionHandler.getContent();
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            Fluid fluid = this.getBucketContent(bucketItem);
            if (Fluids.f_76191_.equals(fluid)) {
                return FluidAmountUtil.EMPTY();
            }
            return FluidAmountUtil.from(fluid, GenericUnit.ONE_BUCKET());
        }
        return FluidAmountUtil.EMPTY();
    }

    public boolean isFluidContainer(ItemStack var1);

    public Component getDisplayName(GenericAmount<FluidLike> var1);

    @NotNull
    public TransferStack fillItem(GenericAmount<FluidLike> var1, ItemStack var2, Player var3, InteractionHand var4, boolean var5);

    @NotNull
    public TransferStack drainItem(GenericAmount<FluidLike> var1, ItemStack var2, Player var3, InteractionHand var4, boolean var5);

    @Nullable
    public SoundEvent getEmptySound(GenericAmount<FluidLike> var1);

    @Nullable
    public SoundEvent getFillSound(GenericAmount<FluidLike> var1);

    public static final class TransferStack {
        private final GenericAmount<FluidLike> moved;
        private final ItemStack toReplace;
        private final boolean shouldMove;

        public TransferStack(GenericAmount<FluidLike> moved, ItemStack toReplace, boolean shouldMove) {
            this.moved = moved;
            this.toReplace = toReplace;
            this.shouldMove = shouldMove;
        }

        public TransferStack(GenericAmount<FluidLike> moved, ItemStack toReplace) {
            this(moved, toReplace, true);
        }

        public GenericAmount<FluidLike> moved() {
            return this.moved;
        }

        public ItemStack toReplace() {
            return this.toReplace;
        }

        public boolean shouldMove() {
            return this.shouldMove;
        }

        public TransferStack setShouldMove(boolean shouldMove) {
            return new TransferStack(this.moved, this.toReplace, shouldMove);
        }

        public String toString() {
            return "TransferStack[moved=" + this.moved + ", toReplace=" + this.toReplace + ", shouldMove=" + this.shouldMove + "]";
        }
    }
}

