/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.contents;

import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.contents.CreativeTank;
import com.kotori316.fluidtank.contents.GenericAccess;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.VoidTank;
import java.io.Serializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.math.BigInt;
import scala.runtime.ModuleSerializationProxy;

public final class TankUtil$
implements Serializable {
    public static final TankUtil$ MODULE$ = new TankUtil$();

    private TankUtil$() {
    }

    static {
        String KEY_TYPE = "type";
        String TYPE_TANK = "Tank";
        String TYPE_CREATIVE_TANK = "CreativeTank";
        String TYPE_VOID_TANK = "VoidTank";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TankUtil$.class);
    }

    public <A> CompoundTag save(Tank<A> tank, GenericAccess<A> access) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.getType(tank));
        tag.m_128365_("content", (Tag)access.write(tank.content()));
        tag.m_128382_("amount_generic", GenericUnit$.MODULE$.asByteArray$extension(tank.capacity()));
        return tag;
    }

    public <A> Tank<A> load(CompoundTag tag, GenericAccess<A> access) {
        if (tag != null && tag.m_128441_("type") && tag.m_128441_("content") && tag.m_128441_("amount_generic")) {
            String tankType = tag.m_128461_("type");
            GenericAmount<A> content = access.read(tag.m_128469_("content"));
            BigInt capacity = GenericUnit$.MODULE$.fromByteArray(tag.m_128463_("amount_generic"));
            String string = tankType;
            switch (string == null ? 0 : string.hashCode()) {
                case -1907460930: {
                    if (!"VoidTank".equals(string)) break;
                    return new VoidTank<A>(content, capacity);
                }
                case 2599178: {
                    if (!"Tank".equals(string)) break;
                    return Tank$.MODULE$.apply(content, capacity);
                }
                case 1942420825: {
                    if (!"CreativeTank".equals(string)) break;
                    return new CreativeTank<A>(content, capacity);
                }
            }
            throw new IllegalArgumentException("Unknown type of tank for %s, %s".formatted(content, tag));
        }
        FluidTankCommon.logOnceInMinute("TankUtil.load No keys", () -> "tag: " + tag, () -> new IllegalArgumentException("Not all required tag are present: " + tag));
        return Tank$.MODULE$.apply(access.newInstance(access.empty(), GenericUnit$.MODULE$.ZERO(), (Option<CompoundTag>)Option$.MODULE$.empty()), GenericUnit$.MODULE$.ZERO());
    }

    private String getType(Tank<?> tank) {
        Tank<?> tank2 = tank;
        if (tank2 instanceof CreativeTank) {
            return "CreativeTank";
        }
        if (tank2 instanceof VoidTank) {
            return "VoidTank";
        }
        if (tank2 instanceof Tank) {
            return "Tank";
        }
        if (tank2 == null) {
            throw new IllegalArgumentException("Unknown type of tank, %s".formatted(tank.getClass()));
        }
        throw new MatchError(tank2);
    }
}

