/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.contents;

import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.Operations$;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.TransferEnv;
import java.util.Objects;
import scala.NotImplementedError;
import scala.math.BigInt;

public class Tank<A> {
    private final GenericAmount content;
    private final BigInt capacity;

    public static <A> Tank<A> apply(GenericAmount<A> genericAmount, BigInt bigInt) {
        return Tank$.MODULE$.apply(genericAmount, bigInt);
    }

    public Tank(GenericAmount<A> content, BigInt capacity) {
        this.content = content;
        this.capacity = capacity;
    }

    public GenericAmount<A> content() {
        return this.content;
    }

    public BigInt capacity() {
        return this.capacity;
    }

    public final BigInt amount() {
        return this.content().amount();
    }

    public final boolean isEmpty() {
        return this.content().isEmpty();
    }

    public final boolean hasContent() {
        return !this.isEmpty();
    }

    public final int hashCode() {
        return Objects.hash(this.content(), this.capacity());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Tank)) return false;
        Tank t = (Tank)object;
        GenericAmount<A> genericAmount = this.content();
        GenericAmount<A> genericAmount2 = t.content();
        if (genericAmount == null) {
            if (genericAmount2 != null) {
                return false;
            }
        } else if (!((Object)genericAmount).equals(genericAmount2)) return false;
        BigInt bigInt = this.capacity();
        BigInt bigInt2 = t.capacity();
        if (bigInt == null) {
            if (bigInt2 == null) return true;
            return false;
        } else {
            if (!bigInt.equals(bigInt2)) return false;
            return true;
        }
    }

    public final String toString() {
        String className = this.getClass().getSimpleName();
        return className + "{content=" + this.content() + ", capacity=" + this.capacity() + "}";
    }

    public Tank<A> copy(GenericAmount<A> content, BigInt capacity) {
        Class<?> clazz = this.getClass();
        Class<Tank> clazz2 = Tank.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return new Tank<A>(content, capacity);
        }
        throw new NotImplementedError("Child classes of Tank must override copy method");
    }

    public GenericAmount<A> copy$default$1() {
        return this.content();
    }

    public BigInt copy$default$2() {
        return this.capacity();
    }

    public IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<A>, GenericAmount<A>, Tank<A>> fillOp() {
        return Operations$.MODULE$.fillOp(this);
    }

    public IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<A>, GenericAmount<A>, Tank<A>> drainOp() {
        return Operations$.MODULE$.drainOp(this);
    }
}

