/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.connection;

import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.implicits$;
import com.kotori316.fluidtank.connection.Connection$;
import com.kotori316.fluidtank.connection.ConnectionHelper;
import com.kotori316.fluidtank.connection.ConnectionHelper$;
import com.kotori316.fluidtank.contents.ChainTanksHandler;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.TanksHandler;
import java.io.Serializable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public abstract class Connection<TileType> {
    private final Seq sortedTanks;
    private final boolean hasCreative;
    private final boolean hasVoid;
    private final boolean isDummy;
    private final TanksHandler handler;

    public static <TankType, ContentType, HandlerType extends ChainTanksHandler<ContentType>> void createAndInit(Seq<TankType> seq, ConnectionHelper connectionHelper) {
        Connection$.MODULE$.createAndInit(seq, connectionHelper);
    }

    public static <TankType extends BlockEntity, ContentType, HandlerType extends ChainTanksHandler<ContentType>> void load(BlockGetter blockGetter, BlockPos blockPos, Class<TankType> clazz, ConnectionHelper connectionHelper) {
        Connection$.MODULE$.load(blockGetter, blockPos, clazz, connectionHelper);
    }

    public static <TileType extends BlockEntity, ConnectionType extends Connection<TileType>> ConnectionType updatePosPropertyAndCreateConnection(Seq<TileType> seq, Function1<Seq<TileType>, ConnectionType> function1) {
        return Connection$.MODULE$.updatePosPropertyAndCreateConnection(seq, function1);
    }

    public Connection(Seq<TileType> sortedTanks) {
        this.sortedTanks = sortedTanks;
        this.hasCreative = sortedTanks.exists((Function1 & Serializable)_$1 -> ConnectionHelper$.MODULE$.ConnectionHelperMethods(_$1, this.helper()).isCreative());
        this.hasVoid = sortedTanks.exists((Function1 & Serializable)_$2 -> ConnectionHelper$.MODULE$.ConnectionHelperMethods(_$2, this.helper()).isVoid());
        this.isDummy = sortedTanks.isEmpty();
        this.handler = this.helper().createHandler(this.sortedTanks());
    }

    public Seq<TileType> sortedTanks() {
        return this.sortedTanks;
    }

    public abstract ConnectionHelper<TileType> helper();

    public boolean hasCreative() {
        return this.hasCreative;
    }

    public boolean hasVoid() {
        return this.hasVoid;
    }

    public final boolean isDummy() {
        return this.isDummy;
    }

    public final TanksHandler handler() {
        return this.handler;
    }

    public Seq<TileType> getTiles() {
        return this.sortedTanks();
    }

    public GenericAmount<Object> contentType() {
        return (GenericAmount)this.sortedTanks().headOption().flatMap((Function1 & Serializable)t -> this.helper().getContent(t)).orElse(this::contentType$$anonfun$2).getOrElse(this::contentType$$anonfun$3);
    }

    public BigInt capacity() {
        return this.handler().getSumOfCapacity();
    }

    public BigInt amount() {
        Object object = Ordering.Implicits$.MODULE$.infixOrderingOps(implicits$.MODULE$.toFoldableOps(this.sortedTanks(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForSeq()).foldMap((Function1 & Serializable)_$3 -> new GenericUnit(this.amount$$anonfun$1(_$3)), GenericUnit$.MODULE$.groupGenericUnit()), GenericUnit$.MODULE$.orderingGenericUnit()).min((Object)new GenericUnit(GenericUnit$.MODULE$.CREATIVE_TANK()));
        if (object == null) {
            return null;
        }
        return ((GenericUnit)object).value();
    }

    public Option<GenericAmount<Object>> getContent() {
        return Option$.MODULE$.apply(this.contentType()).filter((Function1 & Serializable)_$4 -> _$4.nonEmpty()).map((Function1 & Serializable)_$5 -> _$5.setAmount(this.amount()));
    }

    public void remove(TileType tank) {
        if (this.isDummy()) {
            return;
        }
        Tuple2 tuple2 = this.sortedTanks().span((Function1 & Serializable)_$6 -> !BoxesRunTime.equals((Object)_$6, (Object)tank));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq s1 = (Seq)tuple2._1();
        Seq s2 = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)s1, (Object)s2);
        Seq s12 = (Seq)tuple22._1();
        Seq s22 = (Seq)tuple22._2();
        Connection s1Connection = this.helper().createConnection(s12);
        Connection s2Connection = this.helper().createConnection((Seq)s22.tail());
        s12.foreach(this.helper().connectionSetter(s1Connection));
        ((IterableOnceOps)s22.tail()).foreach(this.helper().connectionSetter(s2Connection));
    }

    public int getComparatorLevel() {
        if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)new GenericUnit(this.amount()), GenericUnit$.MODULE$.orderingGenericUnit()).$greater((Object)new GenericUnit(GenericUnit$.MODULE$.ZERO()))) {
            return Mth.m_14107_((double)(GenericUnit$.MODULE$.asForgeDouble$extension(this.amount()) / GenericUnit$.MODULE$.asForgeDouble$extension(this.capacity()) * (double)14)) + 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{tanks=" + this.sortedTanks().size() + ",content=" + this.contentType() + "}";
    }

    private final Option contentType$$anonfun$2() {
        return this.sortedTanks().lastOption().flatMap((Function1 & Serializable)t -> this.helper().getContent(t));
    }

    private final GenericAmount contentType$$anonfun$3() {
        return this.helper().defaultAmount();
    }

    private final /* synthetic */ BigInt amount$$anonfun$1(Object _$3) {
        return ConnectionHelper$.MODULE$.ConnectionHelperMethods(_$3, this.helper()).getAmount();
    }
}

