/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GraveUtils {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    @Nullable
    public static BlockPos getGraveStoneLocation(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos location = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        location.m_122190_((Vec3i)world.m_6857_().m_187569_((double)location.m_123341_(), (double)location.m_123342_(), (double)location.m_123343_()));
        if (world.m_151570_((BlockPos)location) && location.m_123342_() <= world.m_141937_()) {
            location.m_122178_(location.m_123341_(), world.m_141937_() + 1, location.m_123343_());
        }
        while (!world.m_151570_((BlockPos)location)) {
            if (GraveUtils.isReplaceable(world, (BlockPos)location)) {
                return location;
            }
            location.m_122184_(0, 1, 0);
        }
        return null;
    }

    public static boolean isReplaceable(Level world, BlockPos pos) {
        Block b = world.m_8055_(pos).m_60734_();
        if (world.m_46859_(pos)) {
            return true;
        }
        return Main.SERVER_CONFIG.replaceableBlocks.stream().anyMatch(blockTag -> blockTag.contains(b));
    }

    @Nullable
    public static MutableComponent getDate(long timestamp) {
        if (timestamp <= 0L) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(Component.m_237115_((String)"gui.gravestone.date_format").getString());
        return Component.m_237113_((String)dateFormat.format(new Date(timestamp)));
    }

    public static boolean canBreakGrave(Level world, Player player, BlockPos pos) {
        ServerPlayer p;
        if (player.m_21224_()) {
            return false;
        }
        if (!((Boolean)Main.SERVER_CONFIG.onlyOwnersCanBreak.get()).booleanValue()) {
            return true;
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return true;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (player instanceof ServerPlayer && (p = (ServerPlayer)player).m_20310_(p.f_8924_.m_7022_())) {
            return true;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(EMPTY_UUID)) {
            return true;
        }
        return player.m_20148_().equals(uuid);
    }
}

