/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.packets;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import net.minecraft.network.FriendlyByteBuf;

public class CreateTemplatePacket
implements BasePacket {
    private Template template;

    public CreateTemplatePacket(Template template) {
        this.template = template;
    }

    public CreateTemplatePacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        this.template.write(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.template = Template.load(buffer);
    }

    public boolean verify(PacketContext context) {
        return Template.isValidName(this.template.getName());
    }

    public void handle(PacketContext context) {
        TemplateManager templateManager;
        Template sameNameTemplate;
        if (context.getHandlingSide() == CoreSide.SERVER && ((sameNameTemplate = (templateManager = TemplateManager.get(context.getWorld())).getTemplateByName(this.template.getName())) == null || sameNameTemplate.getArea().equals((Object)this.template.getArea()))) {
            TemplateManager.get(context.getWorld()).addTemplate(this.template);
        }
    }
}

