/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class ChiseledBookshelfProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("slotFillChance", (Object)Float.valueOf(0.4f)).forGetter(p -> Float.valueOf(p.slotFillChance))).apply((Applicative)instance, ChiseledBookshelfProcessor::new));
    private final float slotFillChance;

    public ChiseledBookshelfProcessor(float slotFillChance) {
        this.slotFillChance = slotFillChance;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState state = block.state();
        if (state != null && state.m_60713_(Blocks.f_244299_)) {
            NonNullList books = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
            if (block.nbt() != null) {
                ContainerHelper.m_18980_((CompoundTag)block.nbt(), (NonNullList)books);
            }
            RandomSource random = placeSettings.m_230326_(pos);
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)books.get(i)).m_41619_() || !(random.m_188501_() < this.slotFillChance)) continue;
                Enchantment enchantment = (Enchantment)((Holder.Reference)BuiltInRegistries.f_256876_.m_213642_(random).get()).m_203334_();
                ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, random.m_188503_(enchantment.m_6586_()) + 1));
                books.set(i, (Object)book);
                state = (BlockState)state.m_61124_((Property)ChiseledBookShelfBlock.f_260698_.get(i), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag nbt = block.nbt() == null ? new CompoundTag() : block.nbt().m_6426_();
            ContainerHelper.m_18976_((CompoundTag)nbt, (NonNullList)books, (boolean)true);
            return new BlockInstance(state, nbt);
        }
        return block;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)FormationsStructures.CHISELED_BOOKSHELF_PROCESSOR.get();
    }
}

