/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.serialization.Codec;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class BedColorProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    private static final BedColorProcessor INSTANCE = new BedColorProcessor();
    public static final Codec<BedColorProcessor> CODEC = Codec.unit((Object)INSTANCE);
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final Map<DyeColor, BedBlock> COLOR_TO_BED_MAP;
    private static final List<DyeColor> BED_COLORS;

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState state = block.state();
        if (state != null && state.m_60734_() instanceof BedBlock) {
            BlockPos headPosition = state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? pos : pos.m_121945_((Direction)state.m_60715_(placeSettings.m_74401_()).m_60717_(placeSettings.m_74404_()).m_61143_((Property)BlockStateProperties.f_61374_));
            RANDOM.m_188584_(headPosition.m_121878_());
            DyeColor color = BED_COLORS.get(RANDOM.m_188503_(BED_COLORS.size()));
            state = COLOR_TO_BED_MAP.get(color).m_152465_(state);
            return new BlockInstance(state, block.nbt());
        }
        return block;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)FormationsStructures.BED_COLOR_PROCESSOR.get();
    }

    static {
        List<Block> beds = List.of(Blocks.f_50066_, Blocks.f_50067_, Blocks.f_50068_, Blocks.f_50017_, Blocks.f_50018_, Blocks.f_50019_, Blocks.f_50020_, Blocks.f_50021_, Blocks.f_50022_, Blocks.f_50023_, Blocks.f_50024_, Blocks.f_50025_, Blocks.f_50026_, Blocks.f_50027_, Blocks.f_50028_, Blocks.f_50029_);
        COLOR_TO_BED_MAP = beds.stream().filter(BedBlock.class::isInstance).map(BedBlock.class::cast).collect(Collectors.toUnmodifiableMap(BedBlock::m_49554_, o -> o));
        BED_COLORS = Arrays.asList(COLOR_TO_BED_MAP.keySet().toArray(new DyeColor[0]));
    }
}

